/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.client.bean.PhotoLoadTask;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.bean.ContactPhotoTask;
import com.blisscloud.mobile.ezuc.bean.CustomerKey;
import com.blisscloud.mobile.ezuc.bean.CustomerPhotoTask;
import com.blisscloud.mobile.ezuc.bean.EmpKey;
import com.blisscloud.mobile.ezuc.bean.EmpPhotoTask;
import com.blisscloud.mobile.ezuc.bean.MessageChannelPhotoTask;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.db.UCDBMessageChannel;
import com.blisscloud.mobile.ezuc.manager.PhotoType;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.PhotoPair;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class PhotoTaskController
extends ExThread {
    private static PhotoTaskController mInstance;
    private List<PhotoPair> mQueue = Collections.synchronizedList(new ArrayList());
    private boolean suspend = false;

    public synchronized void setSuspend(boolean suspend) {
        this.suspend = suspend;
        if (!suspend && !this.mQueue.isEmpty()) {
            this.notifyAll();
        }
    }

    public static PhotoTaskController getInstance(Context ctx) {
        if (mInstance == null) {
            mInstance = new PhotoTaskController(ctx);
        }
        return mInstance;
    }

    public static void stopInstance() {
        if (mInstance != null) {
            mInstance.terminate();
            mInstance = null;
        }
    }

    public static void suspendInstance(boolean s) {
        if (mInstance != null) {
            mInstance.setSuspend(s);
        }
    }

    private PhotoTaskController(Context ctx) {
        super(ctx, "PhotoTaskController");
        this.start();
    }

    public synchronized void addTask(List<PhotoLoadTask> taskList, PhotoType photoType) {
        if (taskList == null || taskList.isEmpty()) {
            Log.e(this.getClass().getSimpleName(), "GetPhotoTask empIds is null or size is 0");
            return;
        }
        for (PhotoLoadTask task : taskList) {
            if (this.existTask(task, photoType)) continue;
            this.mQueue.add(new PhotoPair(task, photoType));
        }
        this.notifyAll();
    }

    public synchronized void addTask(List<PhotoLoadTask> taskList) {
        if (taskList == null || taskList.isEmpty()) {
            Log.e(this.getClass().getSimpleName(), "GetPhotoTask empIds is null or size is 0");
            return;
        }
        for (PhotoLoadTask task : taskList) {
            if (this.existTask(task, null)) continue;
            this.mQueue.add(new PhotoPair(task, null));
        }
        this.notifyAll();
    }

    private boolean existTask(PhotoLoadTask task, PhotoType photoType) {
        boolean exist = false;
        for (PhotoPair pair : this.mQueue) {
            PhotoLoadTask t2;
            PhotoLoadTask t1;
            if (pair.task instanceof CustomerPhotoTask && task instanceof CustomerPhotoTask) {
                t1 = (CustomerPhotoTask)pair.task;
                t2 = (CustomerPhotoTask)task;
                if (!((CustomerPhotoTask)t1).getCustomerKey().equals(((CustomerPhotoTask)t2).getCustomerKey()) || pair.photoType != photoType) continue;
                exist = true;
                continue;
            }
            if (pair.task instanceof EmpPhotoTask && task instanceof EmpPhotoTask) {
                t1 = (EmpPhotoTask)pair.task;
                t2 = (EmpPhotoTask)task;
                if (!((EmpPhotoTask)t1).getEmpKey().equals(((EmpPhotoTask)t2).getEmpKey()) || pair.photoType != photoType) continue;
                exist = true;
                continue;
            }
            if (pair.task instanceof ContactPhotoTask && task instanceof ContactPhotoTask) {
                t1 = (ContactPhotoTask)pair.task;
                t2 = (ContactPhotoTask)task;
                if (((ContactPhotoTask)t1).getContactId().longValue() != ((ContactPhotoTask)t2).getContactId().longValue() || pair.photoType != photoType) continue;
                exist = true;
                continue;
            }
            if (!(pair.task instanceof MessageChannelPhotoTask) || !(task instanceof MessageChannelPhotoTask)) continue;
            MessageChannelPhotoTask newContactTask = (MessageChannelPhotoTask)pair.task;
            MessageChannelPhotoTask existContactTask = (MessageChannelPhotoTask)task;
            if (!newContactTask.getId().equals(existContactTask.getId())) continue;
            exist = true;
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int x = 1;
            while (!this.isTerminate()) {
                PhotoTaskController photoTaskController = this;
                synchronized (photoTaskController) {
                    if (this.suspend || this.mQueue.isEmpty()) {
                        try {
                            x = 1;
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            Log.e(this.getClass().getSimpleName(), "ERROR:" + e.getMessage());
                        }
                    }
                }
                Log.i(this.getClass().getSimpleName(), "Photo task queue size:" + this.mQueue.size() + ", suspend:" + this.suspend);
                if (this.suspend) continue;
                PhotoPair mCurrentTask = null;
                if (!this.mQueue.isEmpty()) {
                    PhotoTaskController e = this;
                    synchronized (e) {
                        mCurrentTask = this.mQueue.remove(0);
                    }
                }
                if (mCurrentTask == null) continue;
                this.execute(mCurrentTask.task, mCurrentTask.photoType);
                if (x % 10 == 0) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        Log.e(this.getClass().getSimpleName(), "ERROR:" + e.getMessage());
                    }
                    x = 1;
                    continue;
                }
                ++x;
            }
        }
        finally {
            Log.i(this.getClass().getSimpleName(), "Clear instance");
            PhotoTaskController photoTaskController = this;
            synchronized (photoTaskController) {
                this.mQueue.clear();
                this.mQueue = null;
            }
            mInstance = null;
        }
    }

    private void execute(PhotoLoadTask task, PhotoType photoType) {
        if (task instanceof CustomerPhotoTask) {
            CustomerPhotoTask t = (CustomerPhotoTask)task;
            this.getCustomerPhotoFromWeb(this.mCtx, t.getCustomerKey(), photoType);
        } else if (task instanceof EmpPhotoTask) {
            EmpPhotoTask t = (EmpPhotoTask)task;
            EmpKey id = t.getEmpKey();
            long[] timestamps = UCDBContact.getContactPhotoTimestamps(this.mCtx, id.getJid());
            this.getPhotoFromWeb(this.mCtx, id, photoType);
        } else if (task instanceof ContactPhotoTask) {
            ContactPhotoTask t = (ContactPhotoTask)task;
            Long id = t.getContactId();
            this.getPhotoFromWeb(this.mCtx, id, photoType);
        } else if (task instanceof MessageChannelPhotoTask) {
            MessageChannelPhotoTask t = (MessageChannelPhotoTask)task;
            Long id = t.getId();
            this.getChannelPhotoFromWeb(this.mCtx, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getChannelPhotoFromWeb(Context ctx, Long channelId) {
        String url = null;
        InputStream is = null;
        HttpClient mHttpClient = null;
        boolean success = false;
        try {
            url = "https://" + CommonUtil.getHttpsIpPort(ctx) + "/ucrm/apiUser/getIcon?id=" + channelId;
            mHttpClient = CommonUtil.getHttpsClient(ctx, true);
            if (url == null) return;
            if (mHttpClient == null) return;
            Log.i(this.getClass().getSimpleName(), "download url is " + url);
            HttpGet request = new HttpGet();
            request.setURI(new URI(url));
            HttpResponse response = mHttpClient.execute((HttpUriRequest)request);
            Log.i(this.getClass().getSimpleName(), "status line: " + String.valueOf(response.getStatusLine()));
            if (response.getStatusLine().getStatusCode() != 200) {
                request.abort();
                return;
            }
            is = response.getEntity().getContent();
            success = true;
            FileUtil.writeMessageChannelPhoto(channelId, is);
            long t = UCDBMessageChannel.getPhotoTimestamp(ctx, channelId);
            UCDBMessageChannel.updateCurrentPhotoTimestamp(ctx, channelId, t);
            return;
        }
        catch (MalformedURLException e) {
            Log.e(this.getClass().getSimpleName(), e.getLocalizedMessage(), e);
            return;
        }
        catch (URISyntaxException e) {
            Log.e(this.getClass().getSimpleName(), e.getLocalizedMessage(), e);
            return;
        }
        catch (ClientProtocolException e) {
            Log.e(this.getClass().getSimpleName(), e.getLocalizedMessage(), e);
            return;
        }
        catch (IOException e) {
            Log.e(this.getClass().getSimpleName(), e.getLocalizedMessage(), e);
            return;
        }
        finally {
            if (success) {
                BroadcastUtil.sendApiPhotoChangedEvent(ctx, channelId);
            }
            if (is != null) {
                try {
                    try {
                        is.close();
                        is = null;
                    }
                    catch (IOException e) {
                        Log.e(this.getClass().getSimpleName(), "getPhotoFromWeb fail ", e);
                        is = null;
                    }
                }
                catch (Throwable throwable) {
                    is = null;
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCustomerPhotoFromWeb(Context ctx, CustomerKey customerKey, PhotoType photoType) {
        String url = null;
        InputStream is = null;
        HttpClient mHttpClient = null;
        boolean success = false;
        try {
            url = "https://" + CommonUtil.getHttpsIpPort(ctx) + "/ucrm/customer/showBigPhoto?customerId=" + customerKey.getCustomerId();
            mHttpClient = CommonUtil.getHttpsClient(ctx, true);
            if (url != null && mHttpClient != null) {
                Log.i(this.getClass().getSimpleName(), "download url is " + url);
                HttpGet request = new HttpGet();
                request.setURI(new URI(url));
                HttpResponse response = mHttpClient.execute((HttpUriRequest)request);
                Log.i(this.getClass().getSimpleName(), "status line: " + String.valueOf(response.getStatusLine()));
                if (response.getStatusLine().getStatusCode() != 200) {
                    request.abort();
                } else {
                    is = response.getEntity().getContent();
                    success = true;
                    if (photoType == null || photoType == PhotoType.SMALL) {
                        FileUtil.writeJidSmallPhoto(customerKey.getJid(), is);
                        UCDBContact.updateCurrentPhotoTimestamp(ctx, customerKey.getJid(), UCDBContact.getContactPhotoTimestamp(ctx, customerKey.getJid()));
                    } else if (photoType == PhotoType.BIG) {
                        FileUtil.writeJidBigPhoto(customerKey.getJid(), is);
                    }
                }
            }
        }
        catch (Throwable e) {
            Log.e(this.getClass().getSimpleName(), "download url is " + url);
            Log.e(this.getClass().getSimpleName(), "customerKey:" + String.valueOf(customerKey) + ", error:" + e.getLocalizedMessage(), e);
        }
        finally {
            if (success) {
                Log.i(this.getClass().getSimpleName(), "getPhotoFromWeb success ");
                if (PreferencesUtil.isSyncOldChatEventDone(ctx)) {
                    BroadcastUtil.sendContactPhotoChangedEvent(ctx, customerKey.getJid());
                    PhoneAgent.getInstance().onPhotoLoaded(customerKey.getJid());
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Log.e(this.getClass().getSimpleName(), "getPhotoFromWeb fail ", e);
                }
                finally {
                    is = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPhotoFromWeb(Context ctx, Long empKey, PhotoType photoType) {
        String url = null;
        InputStream is = null;
        HttpClient mHttpClient = null;
        boolean success = false;
        try {
            if (photoType == PhotoType.SMALL) {
                url = "https://" + CommonUtil.getHttpsIpPort(ctx) + "/ucrm/contact/showPhoto?contactId=" + empKey;
            } else if (photoType == PhotoType.BIG) {
                url = "https://" + CommonUtil.getHttpsIpPort(ctx) + "/ucrm/contact/showBigPhoto?contactId=" + empKey;
            }
            mHttpClient = CommonUtil.getHttpsClient(ctx, true);
            if (url != null && mHttpClient != null) {
                Log.i(this.getClass().getSimpleName(), "download url is " + url);
                HttpGet request = new HttpGet();
                request.setURI(new URI(url));
                HttpResponse response = mHttpClient.execute((HttpUriRequest)request);
                Log.i(this.getClass().getSimpleName(), "status line: " + String.valueOf(response.getStatusLine()));
                if (response.getStatusLine().getStatusCode() != 200) {
                    request.abort();
                } else {
                    is = response.getEntity().getContent();
                    success = true;
                    if (photoType == null || photoType == PhotoType.SMALL) {
                        FileUtil.writeContactSmallPhoto(empKey, is);
                        UCDBExternalContact.updateCurrentPhotoTimestamp(ctx, empKey, UCDBExternalContact.getContactPhotoTimestamp(ctx, empKey));
                    } else if (photoType == PhotoType.BIG) {
                        FileUtil.writeContactBigPhoto(empKey, is);
                    }
                }
            }
        }
        catch (Throwable e) {
            Log.e(this.getClass().getSimpleName(), "download url is " + url);
            Log.e(this.getClass().getSimpleName(), "empKey:" + empKey + ", error:" + e.getLocalizedMessage(), e);
        }
        finally {
            if (success) {
                BroadcastUtil.sendExternalPhotoChangedEvent(ctx, empKey);
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Log.e(this.getClass().getSimpleName(), "getPhotoFromWeb fail ", e);
                }
                finally {
                    is = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPhotoFromWeb(Context ctx, EmpKey empKey, PhotoType photoType) {
        String url = null;
        InputStream is = null;
        HttpClient mHttpClient = null;
        boolean success = false;
        try {
            if (photoType == PhotoType.SMALL) {
                url = "https://" + CommonUtil.getHttpsIpPort(ctx) + "/ucrm/employee/showPhoto?employeeId=" + empKey.getEmpId();
            } else if (photoType == PhotoType.BIG) {
                url = "https://" + CommonUtil.getHttpsIpPort(ctx) + "/ucrm/employee/showBigPhoto?employeeId=" + empKey.getEmpId();
            }
            mHttpClient = CommonUtil.getHttpsClient(ctx, true);
            if (url != null && mHttpClient != null) {
                Log.i(this.getClass().getSimpleName(), "download url is " + url);
                HttpGet request = new HttpGet();
                request.setURI(new URI(url));
                HttpResponse response = mHttpClient.execute((HttpUriRequest)request);
                Log.i(this.getClass().getSimpleName(), "status line: " + String.valueOf(response.getStatusLine()));
                if (response.getStatusLine().getStatusCode() != 200) {
                    request.abort();
                } else {
                    is = response.getEntity().getContent();
                    success = true;
                    if (photoType == null || photoType == PhotoType.SMALL) {
                        FileUtil.writeJidSmallPhoto(empKey.getJid(), is);
                        UCDBContact.updateCurrentPhotoTimestamp(ctx, empKey.getJid(), UCDBContact.getContactPhotoTimestamp(ctx, empKey.getJid()));
                    } else if (photoType == PhotoType.BIG) {
                        FileUtil.writeJidBigPhoto(empKey.getJid(), is);
                    }
                }
            }
        }
        catch (Throwable e) {
            Log.e(this.getClass().getSimpleName(), "download url is " + url);
            Log.e(this.getClass().getSimpleName(), "empKey:" + String.valueOf(empKey) + ", error:" + e.getLocalizedMessage(), e);
        }
        finally {
            if (success) {
                Log.i(this.getClass().getSimpleName(), "getPhotoFromWeb success ");
                if (PreferencesUtil.isSyncOldChatEventDone(ctx)) {
                    BroadcastUtil.sendContactPhotoChangedEvent(ctx, empKey.getJid());
                    PhoneAgent.getInstance().onPhotoLoaded(empKey.getJid());
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Log.e(this.getClass().getSimpleName(), "getPhotoFromWeb fail ", e);
                }
                finally {
                    is = null;
                }
            }
        }
    }
}

