/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TaskController {
    private static TaskController mInstance;
    private List<ExThread> mList = Collections.synchronizedList(new ArrayList());

    public static TaskController getInstance() {
        if (mInstance == null) {
            mInstance = new TaskController();
        }
        return mInstance;
    }

    public static void stopInstance() {
        if (mInstance != null) {
            mInstance.cleanupAndTerminate();
            mInstance = null;
        }
    }

    private TaskController() {
    }

    public synchronized void addTask(ExThread a) {
        if (this.mList != null) {
            this.mList.add(a);
        }
    }

    public synchronized void removeTask(ExThread a) {
        if (this.mList != null) {
            this.mList.remove(a);
            if (this.mList.isEmpty()) {
                this.destroy();
            }
        }
    }

    public synchronized void cleanupAndTerminate() {
        if (this.mList != null) {
            for (ExThread i : this.mList) {
                i.terminate();
            }
        }
        this.destroy();
    }

    public synchronized void destroy() {
        mInstance = null;
        if (this.mList != null) {
            this.mList.clear();
            this.mList = null;
        }
    }
}

