/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBConf;
import com.blisscloud.mobile.ezuc.db.UCDBRemoteMark;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class UpdateSingleChatRoomInfoTask
extends ExThread {
    private final JSONObject mRoomObj;
    private final JSONObject mParaObj;

    public UpdateSingleChatRoomInfoTask(Context context, JSONObject dataObj, JSONObject paraObj) {
        super(context, "UpdateSingleChatRoomInfoTask");
        this.mRoomObj = dataObj;
        this.mParaObj = paraObj;
    }

    @Override
    public void run() {
        this.doAction();
        this.cleanUp();
    }

    private void doAction() {
        try {
            if (this.mRoomObj == null) {
                return;
            }
            if (!this.mRoomObj.has("roomJid")) {
                return;
            }
            boolean oneRoomHasMembers = PreferencesUtil.isOneRoomNewHasMembers(this.mCtx);
            String chatRoomJid = this.mRoomObj.getString("roomJid");
            WebAgent.getInstance().reportOneRoomInfoGot(chatRoomJid);
            boolean dirty = false;
            if (JidUtil.isChatJid(chatRoomJid)) {
                if (UCDBChatRoom.existChatRoomById(this.mCtx, chatRoomJid) && this.mRoomObj.has("subject")) {
                    subject = this.mRoomObj.getString("subject");
                    oldRoom = UCDBChatRoom.getChatRoom(this.mCtx, chatRoomJid);
                    oldSubject = oldRoom.getSubject();
                    if (oldSubject == null || !oldSubject.equals(subject)) {
                        UCDBChatRoom.updateChatRoomSubject(this.mCtx, chatRoomJid, subject);
                        PhoneAgent.getInstance().onChatRoomTitleChanged(chatRoomJid, subject);
                        dirty = true;
                        Log.d(UpdateSingleChatRoomInfoTask.class.getSimpleName(), "dirty room " + chatRoomJid + " subjectChanged 1, " + oldSubject + " vs " + subject);
                    }
                }
            } else if (JidUtil.isConfJid(chatRoomJid) && UCDBChatRoom.existChatRoomById(this.mCtx, chatRoomJid) && this.mRoomObj.has("subject")) {
                subject = this.mRoomObj.getString("subject");
                oldRoom = UCDBChatRoom.getChatRoom(this.mCtx, chatRoomJid);
                oldSubject = oldRoom.getSubject();
                if (oldSubject == null || !oldSubject.equals(subject)) {
                    UCDBChatRoom.updateChatRoomSubject(this.mCtx, chatRoomJid, subject);
                    dirty = true;
                    Log.d(UpdateSingleChatRoomInfoTask.class.getSimpleName(), "dirty room " + chatRoomJid + " subjectChanged 2, " + oldSubject + " vs " + subject);
                }
            }
            boolean syncDone = PreferencesUtil.isSyncOldChatEventDone(this.mCtx);
            if (oneRoomHasMembers) {
                boolean isInitDone;
                LiteConferenceRoom confRoom = UCDBConf.getConfRoomByChatRoomId(this.mCtx, chatRoomJid);
                if (confRoom != null && !(isInitDone = UCDBConf.isConfInitDone(this.mCtx, confRoom))) {
                    UCDBConf.updateConfRoomInitDoneState(this.mCtx, confRoom.getRoomId(), true);
                    dirty = true;
                    Log.d(UpdateSingleChatRoomInfoTask.class.getSimpleName(), "dirty room " + chatRoomJid + " init done");
                    if (syncDone) {
                        BroadcastUtil.sendMeetmeListChangedEvent(this.mCtx);
                    }
                }
                if (this.mRoomObj.has("members")) {
                    JSONArray ownerObj = this.mRoomObj.getJSONArray("members");
                    if (!ChatRoomManager.checkLoginUserIsOwner(this.mCtx, ownerObj)) {
                        ChatRoomManager.cleanChatRoom(this.mCtx, chatRoomJid, false);
                        dirty = true;
                        Log.d(UpdateSingleChatRoomInfoTask.class.getSimpleName(), "dirty room " + chatRoomJid + " clean room 1");
                    } else {
                        ChatRoomManager.prepareChatRoom(this.mCtx, chatRoomJid);
                        boolean updateParticipant = ChatRoomManager.parseChatRoomParticipant(this.mCtx, ownerObj, chatRoomJid);
                        if (updateParticipant) {
                            dirty = true;
                            Log.d(UpdateSingleChatRoomInfoTask.class.getSimpleName(), "dirty room " + chatRoomJid + " updateParticipant");
                        }
                        if (updateParticipant && syncDone) {
                            BroadcastUtil.sendParticipantChangedEvent(this.mCtx, chatRoomJid);
                        }
                        if (confRoom != null && syncDone) {
                            WebAgent.getInstance().queryMeetMeListUser(confRoom.getRoomId());
                        }
                    }
                } else {
                    ChatRoomManager.cleanChatRoom(this.mCtx, chatRoomJid, false);
                    dirty = true;
                    Log.d(UpdateSingleChatRoomInfoTask.class.getSimpleName(), "dirty room " + chatRoomJid + " clean room 2");
                }
            }
            if (syncDone && dirty) {
                BroadcastUtil.sendChatRoomInfoUpdateEvent(this.mCtx, chatRoomJid);
                BroadcastUtil.sendMsgChangedEvent(this.mCtx, chatRoomJid);
                BroadcastUtil.sendContactHistoryChangedEvent(this.mCtx);
            }
            if (this.mParaObj.has("forSync")) {
                UCDBRemoteMark.deleteSyncChatRoomRemoteMark(this.mCtx, chatRoomJid);
            }
        }
        catch (Throwable e) {
            Log.e(UpdateSingleChatRoomInfoTask.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    private void cleanUp() {
        TaskController.getInstance().removeTask(this);
    }
}

