/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.screen;

import com.blisscloud.ezuc.client.chat.SelectFileHandler;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.screen.CaptureRectangle;
import com.blisscloud.mobile.ezuc.util.FileSelectionCallback;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ScreenCapture
extends JFrame {
    private JPanel commandPanel;
    private JButton btnStartShareRect;
    private JButton btnCancelRect;
    private CaptureRectangle panelCaptureRectangle;
    private FileSelectionCallback mFileCallback;
    private JFrame mainFrame;
    private Rectangle panelCaptureRectangleBounds;
    private Point compPressLoc;
    private Rectangle prevBounds = null;
    private boolean isFull = false;
    private Timer checkLocalTimer = new Timer("ScreenCaptureTimer");
    private ClickType clickType = ClickType.NORMAL;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            UIManager.put("PopupMenu.consumeEventOnClose", Boolean.FALSE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenCapture inst = new ScreenCapture(null, null);
                inst.setVisible(true);
            }
        });
    }

    public ScreenCapture(JFrame mainFrame, FileSelectionCallback mFileCallback) {
        Rectangle rect;
        this.mFileCallback = mFileCallback;
        this.mainFrame = mainFrame;
        this.initGUI();
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        Rectangle mainBounds = null;
        Log.i(ScreenCapture.class.getSimpleName(), "this.mainFrame.getBounds()=>" + String.valueOf(this.mainFrame.getBounds()));
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            for (int i = 0; i < gc.length; ++i) {
                Log.i(ScreenCapture.class.getSimpleName(), "=>" + String.valueOf(gc[i].getBounds()));
                if (this.mainFrame != null && gc[i].getBounds().intersects(this.mainFrame.getBounds())) {
                    mainBounds = gc[i].getBounds();
                }
                virtualBounds = virtualBounds.union(gc[i].getBounds());
            }
        }
        Log.i(ScreenCapture.class.getSimpleName(), "mainBounds=>" + String.valueOf(mainBounds));
        Log.i(ScreenCapture.class.getSimpleName(), "virtualBounds>" + String.valueOf(virtualBounds));
        this.setBounds(virtualBounds);
        if (mainBounds != null) {
            this.panelCaptureRectangle.setLocation(mainBounds.getLocation().x + (mainBounds.width - this.panelCaptureRectangle.getWidth()) / 2 - virtualBounds.getLocation().x, mainBounds.getLocation().y + (mainBounds.height - this.panelCaptureRectangle.getHeight()) / 2);
        } else {
            this.panelCaptureRectangle.setLocation(100, 100);
        }
        Log.i(ScreenCapture.class.getSimpleName(), "panelCaptureRectangle=>" + String.valueOf(this.panelCaptureRectangle.getBounds()));
        if (PreferencesUtil.isLastScreenShotLocUsed() && (rect = PreferencesUtil.getLastScreenShotLoc()) != null) {
            this.panelCaptureRectangle.setBounds(rect);
        }
        this.panelCaptureRectangle.setVisible(true);
        this.setBackground(new Color(0, 0, 0, 0));
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        this.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenCapture.this.cancel();
            }
        });
    }

    private void initGUI() {
        try {
            this.setDefaultCloseOperation(2);
            this.setUndecorated(true);
            this.setAlwaysOnTop(true);
            this.getContentPane().setLayout(null);
            this.panelCaptureRectangle = new CaptureRectangle();
            this.getContentPane().add(this.panelCaptureRectangle);
            GridBagLayout panelCaptureLayout = new GridBagLayout();
            this.panelCaptureRectangle.setDoubleBuffered(true);
            this.panelCaptureRectangle.setOpaque(false);
            this.panelCaptureRectangle.setSize(640, 480);
            this.panelCaptureRectangle.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    ScreenCapture.this.captureAreaMouseDragged(e);
                    ScreenCapture.this.panelCaptureRectangle.createResizeHandle();
                    ScreenCapture.this.panelCaptureRectangle.showCursor(e);
                    PreferencesUtil.setLastScreenShotLoc(ScreenCapture.this.panelCaptureRectangle.getBounds());
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    ScreenCapture.this.panelCaptureRectangle.showCursor(e);
                }
            });
            this.panelCaptureRectangle.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ScreenCapture.this.captureAreaMousePressed(e);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        ScreenCapture.this.switchFullScreen();
                    }
                }
            });
            this.panelCaptureRectangle.setLayout(panelCaptureLayout);
            this.commandPanel = new JPanel();
            this.commandPanel.setOpaque(false);
            this.commandPanel.setAlignmentX(0.5f);
            this.commandPanel.setAlignmentY(0.5f);
            this.commandPanel.setPreferredSize(new Dimension(140, 70));
            this.commandPanel.setMaximumSize(new Dimension(140, 70));
            this.commandPanel.setLayout(new FlowLayout());
            this.panelCaptureRectangle.add(this.commandPanel);
            this.btnCancelRect = new JButton();
            this.commandPanel.add(this.btnCancelRect);
            this.btnCancelRect.setContentAreaFilled(false);
            this.btnCancelRect.setPreferredSize(new Dimension(60, 60));
            this.btnCancelRect.setMaximumSize(new Dimension(60, 60));
            this.btnCancelRect.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/cancel.png")));
            this.btnCancelRect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ScreenCapture.this.cancel();
                }
            });
            this.btnStartShareRect = new JButton();
            this.commandPanel.add(this.btnStartShareRect);
            this.btnStartShareRect.setContentAreaFilled(false);
            this.btnStartShareRect.setPreferredSize(new Dimension(60, 60));
            this.btnStartShareRect.setMaximumSize(new Dimension(60, 60));
            this.btnStartShareRect.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/ok.png")));
            this.btnStartShareRect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ScreenCapture.this.btnScreenCaptureRectActionPerformed(evt);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cancel() {
        this.setVisible(false);
        this.dispose();
        if (this.mainFrame != null) {
            this.mainFrame.setState(0);
        }
        if (this.checkLocalTimer != null) {
            this.checkLocalTimer.cancel();
        }
    }

    protected void switchFullScreen() {
        Rectangle mainBounds = null;
        Rectangle virtualBounds = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            for (int i = 0; i < gc.length; ++i) {
                if (this.mainFrame != null && gc[i].getBounds().intersects(this.mainFrame.getBounds())) {
                    mainBounds = gc[i].getBounds();
                }
                virtualBounds = virtualBounds == null ? new Rectangle(gc[i].getBounds()) : virtualBounds.union(gc[i].getBounds());
            }
        }
        if (mainBounds == null) {
            return;
        }
        if (!this.isFull) {
            this.isFull = true;
            Rectangle temp = this.panelCaptureRectangle.getBounds();
            c = this.panelCaptureRectangle;
            c.setBounds(mainBounds.x - virtualBounds.x, mainBounds.y - virtualBounds.y, mainBounds.width, mainBounds.height);
            c.revalidate();
            c.repaint();
            this.panelCaptureRectangle.setLocation(0, 0);
            this.prevBounds = temp;
        } else {
            this.isFull = false;
            Rectangle temp = this.panelCaptureRectangle.getBounds();
            c = this.panelCaptureRectangle;
            c.setBounds(this.prevBounds);
            c.revalidate();
            c.repaint();
            this.prevBounds = temp;
        }
    }

    public boolean isMac() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.startsWith("mac");
    }

    protected void btnScreenCaptureRectActionPerformed(ActionEvent evt) {
        Rectangle rect = new Rectangle(this.panelCaptureRectangle.getLocationOnScreen(), this.panelCaptureRectangle.getSize());
        final int x = rect.x;
        final int y = rect.y;
        final int width = rect.width;
        final int height = rect.height;
        this.setVisible(false);
        this.dispose();
        this.checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

            @Override
            public void doRun() {
                try {
                    if (ScreenCapture.this.isMac()) {
                        File tempFile = File.createTempFile("screenshot-region", ".png");
                        String[] cmd = new String[]{"screencapture", "-x", "-R", String.format("%d,%d,%d,%d", x, y, width, height), tempFile.getAbsolutePath()};
                        Process p = Runtime.getRuntime().exec(cmd);
                        p.waitFor();
                        BufferedImage image = ImageIO.read(tempFile);
                        tempFile.delete();
                        if (ScreenCapture.this.mainFrame != null) {
                            ScreenCapture.this.mainFrame.setState(0);
                        }
                        SelectFileHandler.handleSelectedFileList(image, ScreenCapture.this.mFileCallback);
                    } else {
                        Robot robot = new Robot();
                        BufferedImage image = robot.createScreenCapture(new Rectangle(x, y, width, height));
                        if (ScreenCapture.this.mainFrame != null) {
                            ScreenCapture.this.mainFrame.setState(0);
                        }
                        SelectFileHandler.handleSelectedFileList(image, ScreenCapture.this.mFileCallback);
                    }
                }
                catch (Throwable t) {
                    Log.e(ScreenCapture.class.getSimpleName(), t.getMessage(), t);
                }
                ScreenCapture.this.checkLocalTimer.cancel();
            }
        }, 500L);
    }

    private void captureAreaMousePressed(MouseEvent e) {
        this.panelCaptureRectangleBounds = this.panelCaptureRectangle.getBounds();
        this.compPressLoc = e.getLocationOnScreen();
        this.clickType = this.panelCaptureRectangle.resizeCornerSE.contains(e.getX(), e.getY()) ? ClickType.SE : (this.panelCaptureRectangle.resizeCornerSW.contains(e.getX(), e.getY()) ? ClickType.SW : (this.panelCaptureRectangle.resizeCornerNE.contains(e.getX(), e.getY()) ? ClickType.NE : (this.panelCaptureRectangle.resizeCornerNW.contains(e.getX(), e.getY()) ? ClickType.NW : (this.panelCaptureRectangle.resizeCornerN.contains(e.getX(), e.getY()) ? ClickType.N : (this.panelCaptureRectangle.resizeCornerS.contains(e.getX(), e.getY()) ? ClickType.S : (this.panelCaptureRectangle.resizeCornerE.contains(e.getX(), e.getY()) ? ClickType.E : (this.panelCaptureRectangle.resizeCornerW.contains(e.getX(), e.getY()) ? ClickType.W : ClickType.NORMAL)))))));
    }

    private void captureAreaMouseDragged(MouseEvent e) {
        Point compDragLoc = e.getLocationOnScreen();
        int diffWidth = compDragLoc.x - this.compPressLoc.x;
        int diffHeight = compDragLoc.y - this.compPressLoc.y;
        if (this.clickType == ClickType.SE) {
            if (this.panelCaptureRectangleBounds.width + diffWidth <= 320) {
                diffWidth = 320 - this.panelCaptureRectangleBounds.width;
            }
            if (this.panelCaptureRectangleBounds.height + diffHeight <= 240) {
                diffHeight = 240 - this.panelCaptureRectangleBounds.height;
            }
            this.panelCaptureRectangle.setSize(this.panelCaptureRectangleBounds.width + diffWidth, this.panelCaptureRectangleBounds.height + diffHeight);
        } else if (this.clickType == ClickType.SW) {
            if (this.panelCaptureRectangleBounds.width - diffWidth <= 320) {
                diffWidth = this.panelCaptureRectangleBounds.width - 320;
            }
            if (this.panelCaptureRectangleBounds.height + diffHeight <= 240) {
                diffHeight = 240 - this.panelCaptureRectangleBounds.height;
            }
            this.panelCaptureRectangle.setBounds(this.panelCaptureRectangleBounds.x + diffWidth, this.panelCaptureRectangleBounds.y, this.panelCaptureRectangleBounds.width - diffWidth, this.panelCaptureRectangleBounds.height + diffHeight);
        } else if (this.clickType == ClickType.NE) {
            if (this.panelCaptureRectangleBounds.width + diffWidth <= 320) {
                diffWidth = 320 - this.panelCaptureRectangleBounds.width;
            }
            if (this.panelCaptureRectangleBounds.height - diffHeight <= 240) {
                diffHeight = this.panelCaptureRectangleBounds.height - 240;
            }
            this.panelCaptureRectangle.setBounds(this.panelCaptureRectangleBounds.x, this.panelCaptureRectangleBounds.y + diffHeight, this.panelCaptureRectangleBounds.width + diffWidth, this.panelCaptureRectangleBounds.height - diffHeight);
        } else if (this.clickType == ClickType.NW) {
            if (this.panelCaptureRectangleBounds.width - diffWidth <= 320) {
                diffWidth = this.panelCaptureRectangleBounds.width - 320;
            }
            if (this.panelCaptureRectangleBounds.height - diffHeight <= 240) {
                diffHeight = this.panelCaptureRectangleBounds.height - 240;
            }
            this.panelCaptureRectangle.setBounds(this.panelCaptureRectangleBounds.x + diffWidth, this.panelCaptureRectangleBounds.y + diffHeight, this.panelCaptureRectangleBounds.width - diffWidth, this.panelCaptureRectangleBounds.height - diffHeight);
        } else if (this.clickType == ClickType.N) {
            if (this.panelCaptureRectangleBounds.height - diffHeight <= 240) {
                diffHeight = this.panelCaptureRectangleBounds.height - 240;
            }
            this.panelCaptureRectangle.setBounds(this.panelCaptureRectangleBounds.x, this.panelCaptureRectangleBounds.y + diffHeight, this.panelCaptureRectangleBounds.width, this.panelCaptureRectangleBounds.height - diffHeight);
        } else if (this.clickType == ClickType.S) {
            if (this.panelCaptureRectangleBounds.height + diffHeight <= 240) {
                diffHeight = 240 - this.panelCaptureRectangleBounds.height;
            }
            this.panelCaptureRectangle.setBounds(this.panelCaptureRectangleBounds.x, this.panelCaptureRectangleBounds.y, this.panelCaptureRectangleBounds.width, this.panelCaptureRectangleBounds.height + diffHeight);
        } else if (this.clickType == ClickType.E) {
            if (this.panelCaptureRectangleBounds.width + diffWidth <= 320) {
                diffWidth = 320 - this.panelCaptureRectangleBounds.width;
            }
            this.panelCaptureRectangle.setBounds(this.panelCaptureRectangleBounds.x, this.panelCaptureRectangleBounds.y, this.panelCaptureRectangleBounds.width + diffWidth, this.panelCaptureRectangleBounds.height);
        } else if (this.clickType == ClickType.W) {
            if (this.panelCaptureRectangleBounds.width - diffWidth <= 320) {
                diffWidth = this.panelCaptureRectangleBounds.width - 320;
            }
            this.panelCaptureRectangle.setBounds(this.panelCaptureRectangleBounds.x + diffWidth, this.panelCaptureRectangleBounds.y, this.panelCaptureRectangleBounds.width - diffWidth, this.panelCaptureRectangleBounds.height);
        } else {
            this.panelCaptureRectangle.setLocation(this.panelCaptureRectangleBounds.x + diffWidth, this.panelCaptureRectangleBounds.y + diffHeight);
        }
        this.panelCaptureRectangle.revalidate();
        this.panelCaptureRectangle.repaint();
    }

    static enum ClickType {
        NORMAL(0),
        NW(1),
        NE(2),
        SW(3),
        SE(4),
        N(5),
        S(6),
        E(7),
        W(8);

        private int id;

        private ClickType(int id) {
            this.id = id;
        }
    }
}

