/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.util;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jcodec.api.FrameGrab;
import org.jcodec.codecs.wav.WavDemuxer;
import org.jcodec.common.DemuxerTrack;
import org.jcodec.common.DemuxerTrackMeta;
import org.jcodec.common.io.FileChannelWrapper;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.model.Picture;
import org.jcodec.containers.mp4.demuxer.MP4Demuxer;
import org.jcodec.scale.AWTUtil;

public class AppUtils {
    public static boolean startChat(Context ctx, final String jid) {
        if (TextUtils.isNotBlank((CharSequence)jid) && ctx != null) {
            ChatRoomManager.checkAndGenerateChatRoomData(ctx, jid, null, true, false);
            final Intent intent = new Intent();
            intent.putExtra("NO_RELOAD_IF_OPEN", true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UCChatClient.getInstance().getMainPanel().showChatroom(jid, intent);
                }
            });
            return false;
        }
        Log.e(AppUtils.class.getSimpleName(), "Invalid parameters for chat!");
        return true;
    }

    public static String genThumbnailPhoto(File imageFile) {
        try {
            Map<String, Object> base64ImageData = GraphicUtil.cropImageAsBase64(imageFile);
            return (String)base64ImageData.get("base64Image");
        }
        catch (Throwable t) {
            Log.e(AppUtils.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
            return null;
        }
    }

    public static String genThumbnailPhoto(BufferedImage originalImage, DemuxerTrackMeta.Orientation rotation) {
        try {
            BufferedImage dest = originalImage;
            if (rotation == DemuxerTrackMeta.Orientation.D_0) {
                dest = FileUtil.rotate(originalImage, 1);
            } else if (rotation == DemuxerTrackMeta.Orientation.D_90) {
                dest = FileUtil.rotate(originalImage, 6);
            } else if (rotation == DemuxerTrackMeta.Orientation.D_180) {
                dest = FileUtil.rotate(originalImage, 3);
            } else if (rotation == DemuxerTrackMeta.Orientation.D_270) {
                dest = FileUtil.rotate(originalImage, 8);
            }
            Map<String, Object> base64ImageData = GraphicUtil.cropImageAsBase64(dest);
            return (String)base64ImageData.get("base64Image");
        }
        catch (Throwable t) {
            Log.e(AppUtils.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getWavDuration(File wavFile) {
        WavDemuxer dm = null;
        try {
            FileChannelWrapper bc = NIOUtils.rwChannel(wavFile);
            dm = new WavDemuxer(bc);
            double durationInSercond = dm.getMeta().getTotalDuration();
            long l = Double.valueOf(durationInSercond * 1000.0).longValue();
            return l;
        }
        catch (Exception ex) {
            Log.e(AppUtils.class.getSimpleName(), "ERROR:" + ex.getMessage(), ex);
            long l = 0L;
            return l;
        }
        finally {
            if (dm != null) {
                try {
                    dm.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getVideoDuration(File videoFile) {
        MP4Demuxer dm = null;
        try {
            FileChannelWrapper bc = NIOUtils.rwChannel(videoFile);
            dm = new MP4Demuxer(bc);
            DemuxerTrack vt = dm.getVideoTrack();
            double durationInSercond = vt.getMeta().getTotalDuration();
            long l = Double.valueOf(durationInSercond * 1000.0).longValue();
            return l;
        }
        catch (Exception ex) {
            Log.e(AppUtils.class.getSimpleName(), "ERROR:" + ex.getMessage(), ex);
            long l = 0L;
            return l;
        }
        finally {
            if (dm != null) {
                try {
                    dm.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String genThumbnailVideo(File videoFile) {
        int frameNumber = 10;
        FileChannelWrapper ch = null;
        try {
            ch = NIOUtils.readableChannel(videoFile);
            FrameGrab grab = FrameGrab.createFrameGrab(ch);
            DemuxerTrackMeta.Orientation rotation = grab.getVideoTrack().getMeta().getOrientation();
            Picture picture = grab.seekToFramePrecise(frameNumber).getNativeFrame();
            String string = AppUtils.genThumbnailPhoto(AWTUtil.toBufferedImage(picture), rotation);
            return string;
        }
        catch (Exception ex) {
            Log.e(AppUtils.class.getSimpleName(), "ERROR:" + ex.getMessage(), ex);
            String string = null;
            return string;
        }
        finally {
            NIOUtils.closeQuietly(ch);
        }
    }
}

