/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.util;

import com.blisscloud.ezuc.client.emoticons.EmoticonUtils;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.mobile.ezuc.bean.PhoneLineInfo;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import com.blisscloud.mobile.ezuc.manager.PhotoType;
import com.blisscloud.mobile.ezuc.util.PopupMsg;
import com.blisscloud.mobile.ezuc.util.PopupMsgUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BroadcastUtil {
    public static void sendNotificationPopupEvent(Context ctx, String jid, String packetId) {
        BroadcastUtil.sendNotificationPopupEvent(ctx, jid, packetId, true);
    }

    public static void sendNotificationPopupEvent(Context ctx, String jid, String packetId, boolean unreadCountApply) {
        PopupMsg msg = PopupMsgUtil.convertPopupMsg(ctx, jid, packetId);
        if (msg == null) {
            return;
        }
        String myJid = PreferencesUtil.getUserJid(ctx);
        HashSet<String> jidsSet = new HashSet<String>();
        jidsSet.add(jid);
        Map<String, Integer> hasMeCountMap = UCDBMessage.hasMeCountForAllRooms(ctx, jidsSet, myJid);
        Integer hasMeCount = hasMeCountMap.get(jid);
        String hasMePrefix = hasMeCount != null && hasMeCount > 0 ? "[" + I18NUtil.getString("chat_label_at_by_others") + "] " : "";
        UserDatabase database = UserDatabase.getDB(ctx);
        if (database.isShowContent()) {
            int notReadSize;
            Object finalDisp;
            if (EmoticonUtils.isStickerContent(msg.getContent())) {
                finalDisp = "[" + I18NUtil.getString("chat_msg_type_sticker") + "]";
            } else {
                String newStr = EmoticonUtils.getEmotionsTextOnly(msg.getContent());
                Object object = finalDisp = newStr == null ? msg.getContent() : newStr;
            }
            if (unreadCountApply && (notReadSize = UCDBMessage.countNotReadMsg(ctx, jid, myJid)) > 1) {
                finalDisp = String.format(I18NUtil.getString("notification_chat_unread_content"), notReadSize) + " " + (String)finalDisp;
            }
            Intent intent = new Intent("ezuc.intent.action.event.NOTIFICATION_POPUP");
            intent.putExtra("jid", jid);
            intent.putExtra("title", msg.getTitle());
            intent.putExtra("content", hasMePrefix + (String)finalDisp);
            intent.putExtra("hasMeCount", hasMeCount);
            intent.putExtra("orgContent", msg.getContent());
            ctx.sendBroadcast(intent);
        } else {
            int productType = PreferencesUtil.getInt(ctx, "PRODUCTTYPE", 0);
            String appTypeName = I18NUtil.getProductName(productType);
            Intent intent = new Intent("ezuc.intent.action.event.NOTIFICATION_POPUP");
            intent.putExtra("title", String.format(I18NUtil.getString("notification_unread_title"), appTypeName));
            String content = I18NUtil.getString("notification_chat_unread_amount");
            intent.putExtra("content", hasMePrefix + content);
            intent.putExtra("hasMeCount", hasMeCount);
            intent.putExtra("orgContent", content);
            ctx.sendBroadcast(intent);
        }
    }

    public static void sendNewFaxNoticeEvent(Context ctx, int count) {
        Intent intent = new Intent("ezuc.intent.action.event.FAX_INCOMING_NOTICE");
        intent.putExtra("count", count);
        ctx.sendBroadcast(intent);
    }

    public static void sendAgentStateChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.AGENT_STATE_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendAgentRoleChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.AGENT_ROLE_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendQueueStateChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.QUEUE_STATE_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendWakeupReconnectEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.WAKEUP_RECONNECT_EVENT");
        ctx.sendBroadcast(intent);
    }

    public static void sendUcrmLoginRequestEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.UCRM_LOGIN_REQUEST");
        ctx.sendBroadcast(intent);
    }

    public static void sendUcrmConnectionRequestEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.UCRM_CONNECTION_REQUEST");
        ctx.sendBroadcast(intent);
    }

    public static void sendStatusBarUpdateEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.UPDATE_STATUS_BAR");
        ctx.sendBroadcast(intent);
    }

    public static void sendStatusButtonUpdateEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.UPDATE_STATUS_BUTTON");
        ctx.sendBroadcast(intent);
    }

    public static void sendUcrmConnectionLostEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.UCRM_CONNECTION_LOST");
        ctx.sendBroadcast(intent);
    }

    public static void sendUcrmConnectionOpenEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.UCRM_CONNECTION_OPEN");
        ctx.sendBroadcast(intent);
    }

    public static void sendUcrmConnectionTimeoutEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.UCRM_CONNECTION_TIMEOUT");
        ctx.sendBroadcast(intent);
    }

    public static void sendUcrmConnectionExceptionEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.UCRM_CONNECTION_EXCEPTION");
        ctx.sendBroadcast(intent);
    }

    public static void sendPhoneServiceBoundedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_SERVICE_BOUNDED");
        ctx.sendBroadcast(intent);
    }

    public static void sendStartPhoneAfterWebLoginRequestEvent(Context ctx, String place) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_SERVICE_START_AFTER_LOGIN");
        intent.putExtra("PLACE", place);
        ctx.sendBroadcast(intent);
    }

    public static void sendStopPhoneServiceRequestEvent(Context ctx, String place) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_SERVICE_STOP_REQUEST");
        intent.putExtra("PLACE", place);
        ctx.sendBroadcast(intent);
    }

    public static void sendRestartPhoneServiceRequestEvent(Context ctx, String place) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_SERVICE_RESTART_REQUEST");
        intent.putExtra("PLACE", place);
        ctx.sendBroadcast(intent);
    }

    public static void sendReloadPhoneServiceRequestEvent(Context ctx, String place) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_SERVICE_RELOAD_REQUEST");
        intent.putExtra("PLACE", place);
        ctx.sendBroadcast(intent);
    }

    public static void sendPhoneRegistrationRequestEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_SERVICE_REGISTRATION_REQUEST");
        ctx.sendBroadcast(intent);
    }

    public static void sendPersonalInfoChanged(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.PERSONAL_INFO_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendMultiLoginDeviceFlashEvent(Context ctx, int count) {
        Intent intent = new Intent("ezuc.intent.action.event.WEB_MULTI_LOGIN_FLASH");
        intent.putExtra("deviceCount", count);
        ctx.sendBroadcast(intent);
    }

    public static void sendParticipantChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_PARTICIPANT_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendUpgradeRequiredEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.UPGRADE_REQUIRED");
        ctx.sendBroadcast(intent);
    }

    public static void sendParticipantChangedEvent(Context ctx, String chatRoomJid) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_PARTICIPANT_CHANGED");
        intent.putExtra("chatId", chatRoomJid);
        ctx.sendBroadcast(intent);
    }

    public static void sendMsgReadStatusChangedEvent(Context ctx, String participantJid) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_MSG_READ_STATUS_CHANGED");
        intent.putExtra("chatId", participantJid);
        ctx.sendBroadcast(intent);
    }

    public static void sendMsgRecalledEvent(Context ctx, String packetId) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_MSG_RECALLED");
        intent.putExtra("chatPacketId", packetId);
        ctx.sendBroadcast(intent);
    }

    public static void sendMsgProgressingEvent(Context ctx, String chatRoomJid, String packetId, String fileName, int percent) {
        Intent intent = new Intent("ezuc.intent.action.event.FILE_UPLOAD_PROGRESSING");
        intent.putExtra("chatId", chatRoomJid);
        intent.putExtra("chatPacketId", packetId);
        intent.putExtra("chatFileName", fileName);
        intent.putExtra("percent", percent);
        ctx.sendBroadcast(intent);
    }

    public static void sendMsgChangedEvent(Context ctx, JSONArray chatRoomJidAry, boolean sendOutChat) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_MSG_CHANGED");
        intent.putExtra("chatAry", chatRoomJidAry);
        intent.putExtra("selfSendOut", sendOutChat);
        ctx.sendBroadcast(intent);
    }

    public static void sendMsgChangedEvent(Context ctx, String chatRoomJid) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_MSG_CHANGED");
        intent.putExtra("chatId", chatRoomJid);
        ctx.sendBroadcast(intent);
    }

    public static void sendMsgChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_MSG_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendMsgReadedEvent(Context ctx, String packetId) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_MSG_READED_BY");
        intent.putExtra("chatPacketId", packetId);
        ctx.sendBroadcast(intent);
    }

    public static void sendMsgDeletedEvent(Context ctx, String packetId) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_MSG_DELETED");
        intent.putExtra("chatPacketId", packetId);
        ctx.sendBroadcast(intent);
    }

    public static void sendUpdateActionMapEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.UPDATE_ACTION_MAP");
        ctx.sendBroadcast(intent);
    }

    public static void sendMsgPlayedEvent(Context ctx, String packetId) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_MSG_PLAYED");
        intent.putExtra("chatPacketId", packetId);
        ctx.sendBroadcast(intent);
    }

    public static void sendMsgChangedEventByPacketId(Context ctx, String chatRoomJid, String packetId) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_MSG_CONTENT_CHANGED");
        intent.putExtra("chatId", chatRoomJid);
        intent.putExtra("chatPacketId", packetId);
        ctx.sendBroadcast(intent);
    }

    public static void sendContactHistoryChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.CONTACT_HISTORY_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendChatRoomMsgDeletedEvent(Context ctx, String roomJid) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_ROOM_MSG_DELETED");
        intent.putExtra("roomJID", roomJid);
        ctx.sendBroadcast(intent);
    }

    public static void sendChatRoomInfoUpdateEvent(Context ctx, String chatRoomJid) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_ROOM_INFO_UPDATE");
        intent.putExtra("roomJID", chatRoomJid);
        ctx.sendBroadcast(intent);
    }

    public static void sendDataDownloadDataReadyEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.NOTIFY_DATA_DOWNLOAD_DATA_READY");
        ctx.sendBroadcast(intent);
    }

    public static void sendDataDownloadStartEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.NOTIFY_DATA_DOWNLOAD_START");
        ctx.sendBroadcast(intent);
    }

    public static void sendDataDownloadProgressEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.NOTIFY_DATA_DOWNLOAD_PROGRESS");
        ctx.sendBroadcast(intent);
    }

    public static void sendDataDownloadEndEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.NOTIFY_DATA_DOWNLOAD_END");
        ctx.sendBroadcast(intent);
    }

    public static void sendExternalPhotoChangedEvent(Context ctx, Long empKey) {
        Intent intent = new Intent("ezuc.intent.action.event.EXTERNAL_PHOTO_CHANGED");
        intent.putExtra("id", empKey);
        intent.putExtra("type", PhotoType.SMALL.toString());
        ctx.sendBroadcast(intent);
    }

    public static void sendContactPhotoChangedEvent(Context ctx, String empJid) {
        Intent intent = new Intent("ezuc.intent.action.event.CONTACT_PHOTO_CHANGED");
        intent.putExtra("jid", empJid);
        intent.putExtra("type", PhotoType.SMALL.toString());
        ctx.sendBroadcast(intent);
    }

    public static void sendJoinConfDoneEvent(Context ctx, int returnCode, String returnInfo) {
        Intent intent = new Intent("ezuc.intent.action.event.EXE_JOIN_CONFERENCE_DONE");
        intent.putExtra("returnCode", returnCode);
        intent.putExtra("returnInfo", returnInfo);
        ctx.sendBroadcast(intent);
    }

    public static void sendDyncConfRoomFoundEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.FIND_DYNC_CONF_ROOM");
        ctx.sendBroadcast(intent);
    }

    public static void sendVerifyPinCodeResultEvent(Context ctx, int returnCode, String returnInfo, JSONObject dataObj, JSONObject paraObj) throws JSONException {
        Intent intent = new Intent("ezuc.intent.action.event.VERIFY_CONFERENCE_PIN_CODE_RESULT");
        intent.putExtra("returnCode", returnCode);
        intent.putExtra("returnInfo", returnInfo);
        intent.putExtra("roomId", paraObj.getLong("roomId"));
        intent.putExtra("jsonData", dataObj.toString());
        ctx.sendBroadcast(intent);
    }

    public static void sendFetchConfRoomMemberListEvent(Context ctx, int returnCode, String returnInfo, JSONArray dataArray, JSONObject paraObj) throws JSONException {
        Intent intent = new Intent("ezuc.intent.action.event.FETCH_CONFERENCE_ROOM_MEMBER_LIST");
        intent.putExtra("returnCode", returnCode);
        intent.putExtra("returnInfo", returnInfo);
        intent.putExtra("roomId", paraObj.getLong("roomId"));
        intent.putExtra("jsonData", dataArray.toString());
        ctx.sendBroadcast(intent);
    }

    public static void sendMeetmeMuteEvent(Context ctx, Long roomId) {
        Intent intent = new Intent("ezuc.intent.action.event.MEET_ME_MUTE");
        intent.putExtra("roomId", roomId);
        ctx.sendBroadcast(intent);
    }

    public static void sendMeetmeUnmuteEvent(Context ctx, Long roomId) {
        Intent intent = new Intent("ezuc.intent.action.event.MEET_ME_UNMUTE ");
        intent.putExtra("roomId", roomId);
        ctx.sendBroadcast(intent);
    }

    public static void sendMeetmeListChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.MEETME_LIST_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendMeetmeUserListChangedEvent(Context ctx, Long roomId) {
        Intent intent = new Intent("ezuc.intent.action.event.MEETME_USER_LIST_CHANGED");
        intent.putExtra("roomId", roomId);
        ctx.sendBroadcast(intent);
    }

    public static void sendMeetmeChangedEvent(Context ctx, Long roomId, String roomJid) {
        Intent intent = new Intent("ezuc.intent.action.event.MEETME_CHANGED");
        intent.putExtra("roomId", roomId);
        if (roomJid != null) {
            intent.putExtra("roomJID", roomJid);
        }
        ctx.sendBroadcast(intent);
    }

    public static void sendMeetmeLockEvent(Context ctx, Long roomId) {
        Intent intent = new Intent("ezuc.intent.action.event.MEET_ME_LOCK");
        intent.putExtra("roomId", roomId);
        ctx.sendBroadcast(intent);
    }

    public static void sendMeetmeUnlockEvent(Context ctx, Long roomId) {
        Intent intent = new Intent("ezuc.intent.action.event.MEET_ME_UNLOCK");
        intent.putExtra("roomId", roomId);
        ctx.sendBroadcast(intent);
    }

    public static void sendMeetmePrefixChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.MEETME_PHONE_PREFIX_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendVoiceRecordChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.VOICE_AND_RECORD_MESSAGE_CHANGE ");
        ctx.sendBroadcast(intent);
    }

    public static void sendCompanyLogoChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.COMPANY_LOGO_CHANGE");
        ctx.sendBroadcast(intent);
    }

    public static void sendCompanyNameChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.COMPANY_NAME_CHANGE");
        ctx.sendBroadcast(intent);
    }

    public static void sendGroupListChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.GROUP_LIST_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendExternalContactListChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.EXTERNAL_CONTACT_LIST_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendExternalContactAddDoneEvent(Context ctx, JSONObject dataObj) {
        Intent intent = new Intent("ezuc.intent.action.event.EXE_EXTERNAL_CONTACT_ADD_DONE");
        intent.putExtra("jsonData", dataObj.toString());
        ctx.sendBroadcast(intent);
    }

    public static void sendCustomerLevelUpdateFailedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.EXE_CUSTOMER_LEVEL_UPDATE_FAILED");
        ctx.sendBroadcast(intent);
    }

    public static void sendCustomerStatusChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.CUSTOMER_STATUS_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendFetchCustomerHistoryLogEvent(Context ctx, String sessionId, JSONArray dataAry) {
        Intent intent = new Intent("ezuc.intent.action.event.FETCH_CUSTOMER_HISTORY_LOG");
        intent.putExtra("SESSION_ID", sessionId);
        intent.putExtra("DATA", dataAry);
        ctx.sendBroadcast(intent);
    }

    public static void sendContactListChangedEvent(Context ctx, int type) {
        Intent intent = new Intent("ezuc.intent.action.event.CONTACT_LIST_CHANGED");
        intent.putExtra("type", type);
        ctx.sendBroadcast(intent);
    }

    public static void sendContactListChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.CONTACT_LIST_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendChatRoomRemovedEvent(Context ctx, String chatRoomJid) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_REMOVE_FROM_CHATROOM");
        intent.putExtra("chatId", chatRoomJid);
        ctx.sendBroadcast(intent);
    }

    public static void sendChatRoomCreateSucceedEvent(Context ctx, String chatRoomJid, String requestId) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_ROOM_CREATED_SUCCEED");
        intent.putExtra("chatId", chatRoomJid);
        intent.putExtra("requestId", requestId);
        ctx.sendBroadcast(intent);
    }

    public static void sendChatRoomCreateFailedEvent(Context ctx, String chatRoomJid) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_ROOM_CREATED_FAILED");
        intent.putExtra("chatId", chatRoomJid);
        ctx.sendBroadcast(intent);
    }

    public static void sendChatRoomJoinOKEvent(Context ctx, String chatRoomJid) {
        Intent intent = new Intent("ezuc.intent.action.event.EXE_CHATROOM_JOIN_DONE");
        intent.putExtra("chatId", chatRoomJid);
        ctx.sendBroadcast(intent);
    }

    public static void sendEmpPhoneStatusChangedEvent(Context ctx, ArrayList<String> phoneStatusList) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_EMP_STATUS_CHANGED");
        intent.putExtra("employeeIdList", phoneStatusList);
        ctx.sendBroadcast(intent);
    }

    public static void sendLocPhoneStatusChangedEvent(Context ctx, ArrayList<String> locPhoneStatusList) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_LOC_STATUS_CHANGED");
        intent.putExtra("locationJidList", locPhoneStatusList);
        ctx.sendBroadcast(intent);
    }

    public static void sendPhoneInfoChanged(Context ctx, int line) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_INFO_CHANGED");
        intent.putExtra("line", line);
        ctx.sendBroadcast(intent);
    }

    public static void sendPhoneInfoChanged(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_INFO_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendPhoneStateChangedEvent(Context ctx, int line) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_STATE_CHANGED");
        intent.putExtra("line", line);
        ctx.sendBroadcast(intent);
    }

    public static void sendPhoneMuteChangedEvent(Context ctx, int line) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_MUTE_CHANGED");
        intent.putExtra("line", line);
        ctx.sendBroadcast(intent);
    }

    public static void sendPhoneRecordingChangedEvent(Context ctx, int line) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_RECORDING_CHANGED");
        intent.putExtra("line", line);
        ctx.sendBroadcast(intent);
    }

    public static void sendPhoneRegistrationOKEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_STATE_SIP_REGISTER_SUCCESS");
        ctx.sendBroadcast(intent);
    }

    public static void sendPhoneRegistrationFailedEvent(Context ctx, String result) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_STATE_SIP_REGISTER_FAIL");
        intent.putExtra("result", result);
        ctx.sendBroadcast(intent);
    }

    public static void sendPhoneUnregistrationDoneEvent(Context ctx, String result) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_STATE_SIP_UNREGISTER_DONE");
        intent.putExtra("result", result);
        ctx.sendBroadcast(intent);
    }

    public static void sendPhoneConnectionFailedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_STATE_SIP_CONNECTION_FAIL");
        ctx.sendBroadcast(intent);
    }

    public static void sendPhoneCallBridgedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_CALL_BRIDGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendPhoneTwoStepTransferEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_TWO_STEP_TRANSFER");
        ctx.sendBroadcast(intent);
    }

    public static void sendPhoneInviteJoinMeetmeEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_INVITE_JOIN_MEETME");
        ctx.sendBroadcast(intent);
    }

    public static void sendPhoneTwoLineOperFailedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.PHONE_TWO_LINE_OPER_FAILED");
        ctx.sendBroadcast(intent);
    }

    public static void sendLoginOKEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.WEB_LOGIN_DONE");
        ctx.sendBroadcast(intent);
    }

    public static void sendWebDisconnectdEvent(Context ctx, int code, String reason) {
        Intent intent = new Intent("ezuc.intent.action.event.WEB_DISCONNECTED");
        intent.putExtra("code", code);
        intent.putExtra("reason", reason);
        ctx.sendBroadcast(intent);
    }

    public static void sendWebTryConnectFailedEvent(Context ctx, int code, String reason) {
        Intent intent = new Intent("ezuc.intent.action.event.WEB_TRY_CONNECT_FAILED");
        intent.putExtra("code", code);
        intent.putExtra("reason", reason);
        ctx.sendBroadcast(intent);
    }

    public static void sendPasswordExpiredEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.PASSWORD_EXPIRED");
        intent.putExtra("expireindays", true);
        ctx.sendBroadcast(intent);
    }

    public static void sendPasswordExpiredNowEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.PASSWORD_EXPIRED");
        intent.putExtra("expirednow", true);
        ctx.sendBroadcast(intent);
    }

    public static void sendFetchVoiceConfigOKEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.FETCH_VOICE_CONFIG");
        ctx.sendBroadcast(intent);
    }

    public static void sendFetchVoiceConfigUpdateDoneEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.EXE_VOICE_CONFIG_UPDATE_DONE");
        ctx.sendBroadcast(intent);
    }

    public static void sendFetchLoginDeviceOKEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.FETCH_LOGIN_DEVICE");
        ctx.sendBroadcast(intent);
    }

    public static void sendFetchDeviceInfoOKEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.FETCH_DEVICE_INFO");
        ctx.sendBroadcast(intent);
    }

    public static void sendDeviceInfoUpdateDoneEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.EXE_DEVICE_UPDATE_DONE");
        ctx.sendBroadcast(intent);
    }

    public static void sendDeviceDeleteDoneEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.EXE_DEVICE_DELETE_DONE");
        ctx.sendBroadcast(intent);
    }

    public static void sendChangePasswordDoneEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.EXE_CHANGE_PASSWORD_DONE");
        ctx.sendBroadcast(intent);
    }

    public static void sendChangePasswordFailedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.EXE_CHANGE_PASSWORD_FAIL");
        ctx.sendBroadcast(intent);
    }

    public static void sendPersonalPhonesUpdateEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.EXE_PERSONAL_PHONES_UPDATE");
        ctx.sendBroadcast(intent);
    }

    public static void sendFetchLanguageListEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.FETCH_LANGUAGE_LIST");
        ctx.sendBroadcast(intent);
    }

    public static void sendCallEmployeeDoneEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.EXE_CALL_EMPLOYEE_DONE");
        ctx.sendBroadcast(intent);
    }

    public static void sendCallEmployeeFailedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.EXE_CALL_EMPLOYEE_FAIL");
        ctx.sendBroadcast(intent);
    }

    public static void sendChatRoomNotificationUpdateEvent(Context ctx, String chatRoomJid) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_ROOM_NOTIFICATION_UPDATE");
        intent.putExtra("roomJID", chatRoomJid);
        ctx.sendBroadcast(intent);
    }

    public static void sendChatRoomExitFailedEvent(Context ctx, String chatRoomJid, String errorMsg) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_ROOM_EXITED_FAILED");
        intent.putExtra("roomJID", chatRoomJid);
        intent.putExtra("errorMsg", errorMsg);
        ctx.sendBroadcast(intent);
    }

    public static void sendMsgGotEvent(Context ctx, String msg) {
        Intent intent = new Intent("ezuc.intent.action.event.GET_MESSAGE");
        intent.putExtra("jsonData", msg);
        ctx.sendBroadcast(intent);
    }

    public static void sendNewUcrmConfigEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.NEW_UCRM_CONFIG");
        ctx.sendBroadcast(intent);
    }

    public static void sendNetworkConnectEvent(Context ctx, int type) {
        Intent intent = new Intent("ezuc.intent.action.event.UC_NETWORK_CONNECTED");
        intent.putExtra("type", type);
        ctx.sendBroadcast(intent);
    }

    public static void sendNetworkChangedEvent(Context ctx, int type) {
        Intent intent = new Intent("ezuc.intent.action.event.UC_NETWORK_CHANGED");
        intent.putExtra("type", type);
        ctx.sendBroadcast(intent);
    }

    public static void sendNetworkDisconnectEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.UC_NETWORK_DISCONNECTED");
        ctx.sendBroadcast(intent);
    }

    public static void sendLogoutEvent(Context ctx, int reason, boolean cleanFlagRequired, String result) {
        Intent intent = new Intent("ezuc.intent.action.event.WEB_LOGOUT_DONE");
        intent.putExtra("LOGOUTCLEANFLAG", cleanFlagRequired);
        intent.putExtra("LOGOUTREASON", reason);
        if (result != null) {
            intent.putExtra("returnInfo", result);
        }
        ctx.sendBroadcast(intent);
    }

    public static void sendLoginFailedEvent(Context ctx, int reason, String result) {
        Intent intent = new Intent("ezuc.intent.action.event.WEB_LOGIN_FAILED");
        intent.putExtra("LOGOUTREASON", reason);
        if (result != null) {
            intent.putExtra("returnInfo", result);
        }
        ctx.sendBroadcast(intent);
    }

    public static void sendSipUnregStateEvent(Context ctx, String reason) {
        Intent intent = new Intent("ezuc.intent.action.event.SIP_EVENT_UNREG_STATE");
        intent.putExtra("KEY_SIP_REASON", reason);
        ctx.sendBroadcast(intent);
    }

    public static void sendSipRegStateEvent(Context ctx, String reason, int statusCode) {
        Intent intent = new Intent("ezuc.intent.action.event.SIP_EVENT_REG_STATE");
        intent.putExtra("KEY_SIP_REASON", reason);
        intent.putExtra("KEY_SIP_STATUS_CODE", statusCode);
        ctx.sendBroadcast(intent);
    }

    public static void sendSipConnectionFailedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.SIP_EVENT_CONNECTION_FAILED");
        ctx.sendBroadcast(intent);
    }

    public static void sendSipRecordingEvent(Context ctx, int line, boolean isRecording) {
        Intent intent = new Intent("ezuc.intent.action.event.SIP_EVENT_RECORDING");
        intent.putExtra("KEY_SIP_LINE", line);
        intent.putExtra("KEY_SIP_IS_RECORDING", isRecording);
        ctx.sendBroadcast(intent);
    }

    public static void sendSipIdleEvent(Context ctx, String caller, String reason, int myLine) {
        Intent intent = new Intent("ezuc.intent.action.event.SIP_EVENT_IDLE");
        intent.putExtra("KEY_SIP_CALLER", caller);
        intent.putExtra("KEY_SIP_REASON", reason);
        intent.putExtra("KEY_SIP_LINE", myLine);
        ctx.sendBroadcast(intent);
    }

    public static void sendSipIncomingEvent(Context ctx, String caller, int myLine, String blinfo, String ruleInfo, String rulePattern, String sipCallId) {
        Intent intent = new Intent("ezuc.intent.action.event.SIP_EVENT_INCOMING_CALL");
        intent.putExtra("KEY_SIP_CALLER", caller);
        intent.putExtra("KEY_SIP_LINE", myLine);
        intent.putExtra("KEY_SIP_BL_INFO", blinfo);
        if (StringUtils.isNotBlank((CharSequence)ruleInfo)) {
            intent.putExtra("KEY_SIP_BL_RULE_INFO", ruleInfo);
        }
        if (StringUtils.isNotBlank((CharSequence)rulePattern)) {
            intent.putExtra("KEY_SIP_BL_PATTERN", rulePattern);
        }
        intent.putExtra("KEY_SIP_CALL_ID", sipCallId);
        ctx.sendBroadcast(intent);
    }

    public static void sendSipOutgoingEvent(Context ctx, String caller, int myLine, String sipCallId) {
        Intent intent = new Intent("ezuc.intent.action.event.SIP_EVENT_OUTGOING_CALL");
        intent.putExtra("KEY_SIP_CALLER", caller);
        intent.putExtra("KEY_SIP_LINE", myLine);
        intent.putExtra("KEY_SIP_CALL_ID", sipCallId);
        ctx.sendBroadcast(intent);
    }

    public static void sendSipNotifyTalkEvent(Context ctx, int myLine) {
        Intent intent = new Intent("ezuc.intent.action.event.SIP_EVENT_NOTIFY_TALK");
        intent.putExtra("KEY_SIP_LINE", myLine);
        ctx.sendBroadcast(intent);
    }

    public static void sendSipNotifyHoldEvent(Context ctx, int myLine) {
        Intent intent = new Intent("ezuc.intent.action.event.SIP_EVENT_NOTIFY_HOLD");
        intent.putExtra("KEY_SIP_LINE", myLine);
        ctx.sendBroadcast(intent);
    }

    public static void sendSipIncallEvent(Context ctx, String caller, int myLine) {
        Intent intent = new Intent("ezuc.intent.action.event.SIP_EVENT_INCALL");
        intent.putExtra("KEY_SIP_CALLER", caller);
        intent.putExtra("KEY_SIP_LINE", myLine);
        ctx.sendBroadcast(intent);
    }

    public static void sendSipOnHoldEvent(Context ctx, String caller, int myLine) {
        Intent intent = new Intent("ezuc.intent.action.event.SIP_EVENT_HOLD");
        intent.putExtra("KEY_SIP_CALLER", caller);
        intent.putExtra("KEY_SIP_LINE", myLine);
        ctx.sendBroadcast(intent);
    }

    public static void sendSipMuteEvent(Context ctx, int myLine, boolean isMute) {
        Intent intent = new Intent("ezuc.intent.action.event.SIP_EVENT_MUTE");
        intent.putExtra("KEY_SIP_LINE", myLine);
        intent.putExtra("KEY_SIP_IS_MUTE", isMute);
        ctx.sendBroadcast(intent);
    }

    public static void sendSipRecordingReadyEvent(Context ctx, String caller, int myLine, String reason, long recStartTime, long recStopTime, File recordingFile, PhoneLineInfo lineInfo) {
        Intent intent = new Intent("ezuc.intent.action.event.SIP_EVENT_RECORDING_READY");
        intent.putExtra("KEY_SIP_CALLER", caller);
        intent.putExtra("KEY_SIP_LINE", myLine);
        intent.putExtra("KEY_SIP_REASON", reason);
        intent.putExtra("KEY_REC_START_TIME", recStartTime);
        intent.putExtra("KEY_REC_END_TIME", recStopTime);
        intent.putExtra("KEY_RECORDING_FILE_PATH", recordingFile.getAbsoluteFile());
        intent.putExtra("KEY_SIP_LINE_INFO", lineInfo);
        ctx.sendBroadcast(intent);
    }

    public static void sendSipCallFailedEvent(Context ctx, int myLine, int result) {
        Intent intent = new Intent("ezuc.intent.action.event.SIP_EVENT_CALL_FAILED");
        intent.putExtra("KEY_SIP_LINE", myLine);
        intent.putExtra("KEY_SIP_CALL_FAILED_RESULT", result);
        ctx.sendBroadcast(intent);
    }

    public static void sendBulletinListChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.BULLETIN_LIST_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendBulletinListAddEvent(Context ctx, int count) {
        Intent intent = new Intent("ezuc.intent.action.event.BULLETIN_LIST_ADDED");
        intent.putExtra("count", count);
        ctx.sendBroadcast(intent);
    }

    public static void sendApiListListChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.MESSAGE_CHANNEL_LIST_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendApiPhotoChangedEvent(Context ctx, Long channelId) {
        Intent intent = new Intent("ezuc.intent.action.event.MESSAGE_CHANNEL_PHOTO_CHANGED");
        intent.putExtra("id", channelId);
        ctx.sendBroadcast(intent);
    }

    public static void sendBulletinDetailReadyEvent(Context ctx, long bulletinId) {
        Intent intent = new Intent("ezuc.intent.action.event.BULLETIN_DETAIL_READY");
        intent.putExtra("bulletinId", bulletinId);
        ctx.sendBroadcast(intent);
    }

    public static void sendBulletinStatusChangedEvent(Context ctx, long bulletinId) {
        Intent intent = new Intent("ezuc.intent.action.event.BULLETIN_STATUS_CHANGED");
        intent.putExtra("bulletinId", bulletinId);
        ctx.sendBroadcast(intent);
    }

    public static void sendBulletinSubjectPhotoReadyEvent(Context ctx, long bulletinId) {
        Intent intent = new Intent("ezuc.intent.action.event.BULLETIN_SUBJECT_PHOTO_READY");
        intent.putExtra("bulletinId", bulletinId);
        ctx.sendBroadcast(intent);
    }

    public static void sendNewVersionReadyFlashEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.SETTING_NEW_VERSION_FLASH");
        ctx.sendBroadcast(intent);
    }

    public static void sendLoginUserSiteChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.LOGIN_USER_SITE_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendCurrentSiteChanged(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.CURRENT_SITE_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendOutboundPrefixListChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.OUTBOUND_REFIX_LIST_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendChatMsgReaderListChanged(Context ctx, String packetId) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_MSG_READER_LIST_CHANGED");
        intent.putExtra("chatPacketId", packetId);
        ctx.sendBroadcast(intent);
    }

    public static void sendEmpExtendedSysModeChanged(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.EMP_EXTENDED_SYS_MODE_CHANGE");
        ctx.sendBroadcast(intent);
    }

    public static void sendAuthOptionChanged(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.AUTH_OPTION_CHANGE");
        ctx.sendBroadcast(intent);
    }

    public static void sendChatSyncAfterwork(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_SYNC_AFTERWORK");
        ctx.sendBroadcast(intent);
    }

    public static void sendMsgStatusChangedEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_MSG_STATUS_CHANGED");
        ctx.sendBroadcast(intent);
    }

    public static void sendMsgStatusChangedEvent(Context ctx, String chatRoomJid, String packetId) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_MSG_STATUS_CHANGED");
        intent.putExtra("chatId", chatRoomJid);
        intent.putExtra("chatPacketId", packetId);
        ctx.sendBroadcast(intent);
    }

    public static void sendMsgStatusChangedEvent(Context ctx, String chatRoomJid, String packetId, String status, String errorMsg) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_MSG_STATUS_CHANGED");
        intent.putExtra("chatId", chatRoomJid);
        intent.putExtra("chatPacketId", packetId);
        intent.putExtra("chatMsgStatus", status);
        if (errorMsg != null) {
            intent.putExtra("errorMsg", errorMsg);
        }
        ctx.sendBroadcast(intent);
    }

    public static void sendMsgOKStatusEvent(Context ctx, String chatRoomJid, String packetId, String fileName, String fileContent, String fileDownloadURL) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_MSG_STATUS_CHANGED");
        intent.putExtra("chatId", chatRoomJid);
        intent.putExtra("chatPacketId", packetId);
        intent.putExtra("chatMsgStatus", "UPLOAD_SUCCEED");
        intent.putExtra("chatFileName", fileName);
        intent.putExtra("chatFileContent", fileContent);
        intent.putExtra("chatFileDownloadURL", fileDownloadURL);
        ctx.sendBroadcast(intent);
    }

    public static void sendMsgFailedEvent(Context ctx, String chatRoomJid, String packetId, String fileName, String errorMsg) {
        Intent intent = new Intent("ezuc.intent.action.event.CHAT_MSG_STATUS_CHANGED");
        intent.putExtra("chatId", chatRoomJid);
        intent.putExtra("chatPacketId", packetId);
        intent.putExtra("chatMsgStatus", "UPLOAD_FAILED");
        intent.putExtra("chatFileName", fileName);
        if (errorMsg != null) {
            intent.putExtra("errorMsg", errorMsg);
        }
        ctx.sendBroadcast(intent);
    }

    public static void sendSatisfactionSurveyListUpdateEvent(Context ctx) {
        Intent intent = new Intent("ezuc.intent.action.event.SATISFACTION_SURVEY_LIST_UPDATE");
        ctx.sendBroadcast(intent);
    }

    public static void sendCancelFreeSeatingResult(Context ctx, int returnCode) {
        Intent intent = new Intent("ezuc.intent.action.event.CANCEL_FREE_SEATING_RESULT");
        intent.putExtra("returnCode", returnCode);
        ctx.sendBroadcast(intent);
    }

    public static void sendRequestFreeSeatingResult(Context ctx, int returnCode) {
        Intent intent = new Intent("ezuc.intent.action.event.REQUEST_FREE_SEATING_RESULT");
        intent.putExtra("returnCode", returnCode);
        ctx.sendBroadcast(intent);
    }

    public static void sendMicLevel(Context ctx, int level) {
        Intent intent = new Intent("ezuc.intent.action.event.MIC_LEVEL_CHANGED");
        intent.putExtra("level", level);
        ctx.sendBroadcast(intent);
    }
}

