/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.util;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.SelectFileHandler;
import com.blisscloud.ezuc.client.component.UCUploadFileChooser;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.FaxSelectionCallback;
import com.blisscloud.mobile.ezuc.util.FileSelectionCallback;
import com.blisscloud.mobile.ezuc.util.FileSizeFormat;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.jpeg.JpegDirectory;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.SwingUtilities;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class FileUtil {
    private static File appRootDir = null;
    private static File databaseDir = null;
    private static File downloadDir = null;
    private static File tempDir = null;
    private static final String CACHE_LOGO_FOLDER = "cacheLogo";
    private static final String CACHE_PHOTO_FOLDER = "cachePhoto";
    private static final String EXTERNAL_FILE_FOLDER = "externalFile";
    private static final String UPDATE_FOLDER = "update";
    private static final String BULLETIN_ATTACHMENT_FOLDER = "attachment";
    private static final String DATABASE_DIR = "database";
    private static final String DOWNLOAD_DIR = "download";
    private static final String TEMP_DIR = "tmp";
    private static final String _SUBJECT_SUFFIX = "_subject";
    private static final String BULLETIN_PREFIX_ = "bulletin_";
    private static FileSizeFormat fileSizeFormat = new FileSizeFormat();
    private static Object lock = new Object();
    public static final int EOF = -1;

    public static void deleteDirectory(File path) {
        if (path == null) {
            return;
        }
        if (path.exists()) {
            FileUtil.cleanDir(path);
            path.delete();
        }
    }

    private static void cleanDir(File path) {
        for (File f : path.listFiles()) {
            if (f.isDirectory()) {
                FileUtil.deleteDirectory(f);
                continue;
            }
            f.delete();
        }
    }

    private static void checkAndCreate(File checkDir) {
        if (!checkDir.exists()) {
            checkDir.mkdirs();
        }
    }

    public static String formatFileSize(long bytes) {
        return fileSizeFormat.format(bytes);
    }

    public static String getFileExtension(File file) {
        return FileUtil.getFileExtension(file.getName());
    }

    public static String extractFileName(String filePathName) {
        if (filePathName == null) {
            return "NA";
        }
        int idx = (filePathName = filePathName.replace("\\", "/")).lastIndexOf("/");
        return idx >= 0 ? filePathName.substring(idx + 1) : filePathName;
    }

    public static String getFileExtension(String fileName) {
        String fileExt = (fileName = fileName.toLowerCase()).lastIndexOf(46) < 0 ? "" : fileName.substring(fileName.lastIndexOf(46) + 1);
        return fileExt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeFileLocale(File folder, String fileName, InputStream input) {
        boolean bl;
        File file;
        FileOutputStream output;
        block8: {
            output = null;
            file = null;
            if (!folder.exists() && !folder.mkdirs()) {
                Log.e(FileUtil.class.getSimpleName(), "write file fail! : create folder fail!" + folder.getAbsolutePath());
                return false;
            }
            file = new File(folder, fileName);
            if (file.exists()) {
                file.delete();
                Log.i(FileUtil.class.getSimpleName(), fileName + " delete older file first!");
            }
            if (file.createNewFile()) break block8;
            boolean bl2 = false;
            FileUtil.close(output);
            output = null;
            return bl2;
        }
        try {
            output = new FileOutputStream(file);
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
            Log.i(FileUtil.class.getSimpleName(), "create new file " + fileName + " done!");
            bl = true;
        }
        catch (Throwable e) {
            boolean bl3;
            try {
                Log.e(FileUtil.class.getSimpleName(), "writePhoto fail!", e);
                file.delete();
                bl3 = false;
            }
            catch (Throwable throwable) {
                FileUtil.close(output);
                output = null;
                throw throwable;
            }
            FileUtil.close(output);
            output = null;
            return bl3;
        }
        FileUtil.close(output);
        output = null;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readFileHandleExif(File file) {
        Object object = lock;
        synchronized (object) {
            return FileUtil.readFileLocal(file, true);
        }
    }

    private static BufferedImage readFileHandleExif(File folder, String filename) {
        if (!folder.exists()) {
            Log.w(FileUtil.class.getSimpleName(), "read file fail!: folder not found" + folder.getAbsolutePath());
            return null;
        }
        File file = new File(folder, filename);
        return FileUtil.readFileHandleExif(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage readFileLocal(File file, boolean readExif) {
        if (!file.exists()) {
            Log.d(FileUtil.class.getSimpleName(), "read file fail!: file not found" + file.getAbsolutePath());
            return null;
        }
        ImageInputStream iis = null;
        BufferedImage originalImage = null;
        try {
            iis = ImageIO.createImageInputStream(file);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                ImageReadParam param = reader.getDefaultReadParam();
                reader.setInput(iis);
                int imageIndex = 0;
                int width = reader.getWidth(imageIndex);
                int height = reader.getHeight(imageIndex);
                int ratio = 1;
                while (width * height / (ratio * ratio) > 4000000) {
                    ratio *= 2;
                }
                param.setSourceSubsampling(ratio, ratio, 0, 0);
                originalImage = reader.read(imageIndex, param);
            }
        }
        catch (Exception e) {
            Log.e(FileUtil.class.getSimpleName(), "reader.read failed, path:" + file.getAbsolutePath(), e);
        }
        finally {
            FileUtil.close(iis);
            iis = null;
        }
        if (originalImage == null) {
            try {
                originalImage = ImageIO.read(file);
            }
            catch (Exception e) {
                Log.e(FileUtil.class.getSimpleName(), "ImageIO.read failed, path:" + file.getAbsolutePath(), e);
            }
        }
        if (readExif && originalImage != null) {
            try {
                return FileUtil.convertExif(file, originalImage);
            }
            catch (Exception e) {
                Log.e(FileUtil.class.getSimpleName(), "ImageIO.read failed, path:" + file.getAbsolutePath(), e);
            }
        }
        return originalImage;
    }

    public static BufferedImage convertExif(File imageFile, BufferedImage originalImage) throws Exception {
        Metadata metadata = ImageMetadataReader.readMetadata((File)imageFile);
        if (metadata == null) {
            return originalImage;
        }
        ExifIFD0Directory exifIFD0Directory = (ExifIFD0Directory)metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
        if (exifIFD0Directory == null) {
            return originalImage;
        }
        JpegDirectory jpegDirectory = (JpegDirectory)metadata.getFirstDirectoryOfType(JpegDirectory.class);
        if (jpegDirectory == null) {
            return originalImage;
        }
        int orientation = 1;
        try {
            if (exifIFD0Directory.containsTag(274)) {
                orientation = exifIFD0Directory.getInt(274);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return FileUtil.rotate(originalImage, orientation);
    }

    public static BufferedImage rotate(BufferedImage originalImage, int orientation) {
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        int translateWidth = width;
        int translateHeight = height;
        AffineTransform affineTransform = new AffineTransform();
        switch (orientation) {
            case 1: {
                break;
            }
            case 2: {
                affineTransform.scale(-1.0, 1.0);
                affineTransform.translate(-width, 0.0);
                break;
            }
            case 3: {
                affineTransform.translate(width, height);
                affineTransform.rotate(Math.PI);
                break;
            }
            case 4: {
                affineTransform.scale(1.0, -1.0);
                affineTransform.translate(0.0, -height);
                break;
            }
            case 5: {
                affineTransform.rotate(-1.5707963267948966);
                affineTransform.scale(-1.0, 1.0);
                break;
            }
            case 6: {
                affineTransform.translate(height, 0.0);
                affineTransform.rotate(1.5707963267948966);
                translateWidth = height;
                translateHeight = width;
                break;
            }
            case 7: {
                affineTransform.scale(-1.0, 1.0);
                affineTransform.translate(-height, 0.0);
                affineTransform.translate(0.0, width);
                affineTransform.rotate(4.71238898038469);
                break;
            }
            case 8: {
                affineTransform.translate(0.0, width);
                affineTransform.rotate(4.71238898038469);
                translateWidth = height;
                translateHeight = width;
                break;
            }
        }
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        BufferedImage destinationImage = new BufferedImage(translateWidth, translateHeight, originalImage.getType());
        return affineTransformOp.filter(originalImage, destinationImage);
    }

    private static void deleteFileLocale(File folder, String filename) {
        File file = null;
        if (folder.exists() && (file = new File(folder, filename)).exists() && !file.delete()) {
            Log.e(FileUtil.class.getSimpleName(), "delete file fail!" + filename);
        }
    }

    public static void close(ImageInputStream i) {
        if (i != null) {
            try {
                i.close();
            }
            catch (IOException e) {
                Log.e(FileUtil.class.getSimpleName(), "close stream fail!", e);
            }
            finally {
                i = null;
            }
        }
    }

    public static void close(InputStream i) {
        if (i != null) {
            try {
                i.close();
            }
            catch (IOException e) {
                Log.e(FileUtil.class.getSimpleName(), "close stream fail!", e);
            }
            finally {
                i = null;
            }
        }
    }

    public static void close(OutputStream i) {
        if (i != null) {
            try {
                i.close();
            }
            catch (IOException e) {
                Log.e(FileUtil.class.getSimpleName(), "close stream fail!", e);
            }
            finally {
                i = null;
            }
        }
    }

    public static String getFileMimeType(String fileName) {
        String mimeType = null;
        if (fileName.toLowerCase().endsWith("pdf")) {
            mimeType = "application/pdf";
        } else if (fileName.toLowerCase().endsWith("doc")) {
            mimeType = "application/msword";
        } else if (fileName.toLowerCase().endsWith("docx")) {
            mimeType = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
        } else if (fileName.toLowerCase().endsWith("xls")) {
            mimeType = "application/vnd.ms-excel";
        } else if (fileName.toLowerCase().endsWith("xlsx")) {
            mimeType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        } else if (fileName.toLowerCase().endsWith("ppt")) {
            mimeType = "application/mspowerpoint";
        } else if (fileName.toLowerCase().endsWith("pptx")) {
            mimeType = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
        } else if (fileName.toLowerCase().endsWith("pps")) {
            mimeType = "application/vnd.ms-powerpoint";
        } else if (fileName.toLowerCase().endsWith("ppsx")) {
            mimeType = "application/vnd.openxmlformats-officedocument.presentationml.slideshow";
        } else if (fileName.toLowerCase().endsWith("vsd")) {
            mimeType = "application/vnd.visio";
        } else if (fileName.toLowerCase().endsWith("log")) {
            mimeType = "text/plain";
        } else if (fileName.toLowerCase().endsWith("txt")) {
            mimeType = "text/plain";
        } else if (fileName.toLowerCase().endsWith("text")) {
            mimeType = "text/plain";
        } else if (fileName.toLowerCase().endsWith("rtf")) {
            mimeType = "text/rtf";
        } else if (fileName.toLowerCase().endsWith("csv")) {
            mimeType = "text/csv";
        } else {
            mimeType = URLConnection.guessContentTypeFromName(fileName);
            if (mimeType == null) {
                Path path = new File(fileName).toPath();
                try {
                    mimeType = Files.probeContentType(path);
                }
                catch (IOException e) {
                    Log.e(FileUtil.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
                }
            }
        }
        return mimeType;
    }

    public static void sendFile(final FileSelectionCallback callback) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FileChooser fc = new FileChooser();
                UCUploadFileChooser.setInitialOpenDir(fc);
                fc.getExtensionFilters().clear();
                fc.getExtensionFilters().add(new FileChooser.ExtensionFilter(I18NUtil.getString("common_all_files"), new String[]{"*.*"}));
                fc.getExtensionFilters().add(UCUploadFileChooser.getExtensionFilter(I18NUtil.getString("chat_msg_type_image"), UCUploadFileChooser.IMAGE_TYPES, null, null));
                fc.getExtensionFilters().add(UCUploadFileChooser.getExtensionFilter(I18NUtil.getString("chat_msg_type_file"), UCUploadFileChooser.DOCUMENT_TYPES, UCUploadFileChooser.AUDIO_TYPES, UCUploadFileChooser.VIDEO_TYPES));
                final List selectedFiles = fc.showOpenMultipleDialog(null);
                if (selectedFiles != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SelectFileHandler.handleSelectedFileList(selectedFiles, callback);
                            if (selectedFiles.size() > 0) {
                                PreferencesUtil.setChatLastOpenDir(UCChatClient.context, ((File)selectedFiles.get(0)).getParentFile().getAbsolutePath());
                            }
                        }
                    });
                }
            }
        });
    }

    public static void sendFax(final String phoneNumber, final FaxSelectionCallback callback) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FileChooser fc = new FileChooser();
                UCUploadFileChooser.setInitialOpenDir(fc);
                fc.getExtensionFilters().clear();
                fc.getExtensionFilters().add(new FileChooser.ExtensionFilter(I18NUtil.getString("common_all_files"), new String[]{"*.*"}));
                fc.getExtensionFilters().add(UCUploadFileChooser.getExtensionFilter(I18NUtil.getString("chat_msg_type_file"), UCUploadFileChooser.FAX_TYPES, null, null));
                final File selectedFile = fc.showOpenDialog(null);
                if (selectedFile != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<File> fileList = new ArrayList<File>();
                            fileList.add(selectedFile);
                            SelectFileHandler.handleSelectedFileForFax(fileList, phoneNumber, callback);
                            PreferencesUtil.setChatLastOpenDir(UCChatClient.context, selectedFile.getParentFile().getAbsolutePath());
                        }
                    });
                }
            }
        });
    }

    public static String getFileSizeText(long bytes) {
        if (bytes <= 0L) {
            return String.format(I18NUtil.getString("media_file_size"), "0 Byte");
        }
        return String.format(I18NUtil.getString("media_file_size"), FileUtil.convertFileSizeDisplay(bytes));
    }

    public static String convertFileSizeDisplay(long bytes) {
        if (bytes <= 0L) {
            return "0 Byte";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(bytes) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)bytes / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static File getAppRootDir() {
        if (appRootDir == null) {
            appRootDir = new File(System.getProperty("user.home") + File.separator + "ucChatClient");
        }
        FileUtil.checkAndCreate(appRootDir);
        return appRootDir;
    }

    public static File getDatabaseDir() {
        if (databaseDir == null) {
            databaseDir = new File(FileUtil.getAppRootDir(), DATABASE_DIR);
        }
        FileUtil.checkAndCreate(databaseDir);
        return databaseDir;
    }

    public static File getDownloadDir() {
        if (downloadDir == null) {
            downloadDir = new File(FileUtil.getAppRootDir(), DOWNLOAD_DIR);
        }
        FileUtil.checkAndCreate(downloadDir);
        return downloadDir;
    }

    public static File getTempDir() {
        if (tempDir == null) {
            tempDir = new File(FileUtil.getAppRootDir(), TEMP_DIR);
        }
        FileUtil.checkAndCreate(tempDir);
        return tempDir;
    }

    public static void cleanTempDir() {
        FileUtil.cleanDir(FileUtil.getTempDir());
    }

    public static File getTempFile(String fileName) {
        return new File(FileUtil.getTempDir(), fileName);
    }

    public static File getDownloadCacheFile(String fileDownloadURL) {
        try {
            File tempDir = FileUtil.getTempDir();
            URI downloadURI = new URI(fileDownloadURL);
            List params = URLEncodedUtils.parse((URI)downloadURI, (String)"UTF-8");
            HashMap<String, String> paramMap = new HashMap<String, String>();
            for (NameValuePair param : params) {
                paramMap.put(param.getName(), param.getValue());
            }
            if (paramMap.containsKey("bulletinId")) {
                String bulletinId = (String)paramMap.get("bulletinId");
                return new File(tempDir, "bulletinId_" + bulletinId + ".png");
            }
            String accessId = (String)paramMap.get("accessId");
            String extension = (String)paramMap.get("extension");
            return new File(tempDir, accessId + "." + extension);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static File getPhotoRoot() {
        File docDir = FileUtil.getAppRootDir();
        File empPhotoDir = new File(docDir, CACHE_PHOTO_FOLDER);
        FileUtil.checkAndCreate(empPhotoDir);
        return empPhotoDir;
    }

    public static File getLogoPhotoRoot() {
        File docDir = FileUtil.getAppRootDir();
        File logoPhotoDir = new File(docDir, CACHE_LOGO_FOLDER);
        FileUtil.checkAndCreate(logoPhotoDir);
        return logoPhotoDir;
    }

    public static File getExternalFileRoot() {
        File docDir = FileUtil.getAppRootDir();
        File forder = new File(docDir, EXTERNAL_FILE_FOLDER);
        FileUtil.checkAndCreate(forder);
        return forder;
    }

    public static File getUpdateRoot(boolean cleanIfExist) {
        File docDir = FileUtil.getAppRootDir();
        File forder = new File(docDir, UPDATE_FOLDER);
        if (cleanIfExist && forder.exists()) {
            FileUtil.deleteDirectory(forder);
        }
        FileUtil.checkAndCreate(forder);
        return forder;
    }

    public static void cleanUserPhoto() {
        File photoDir = FileUtil.getPhotoRoot();
        FileUtil.deleteDirectory(photoDir);
    }

    public static File getExternalFileDir(String type) {
        File root = FileUtil.getExternalFileRoot();
        File forder = new File(root, type);
        FileUtil.checkAndCreate(forder);
        return forder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJidSmallPhoto(String jid, InputStream input) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            FileUtil.writeFileLocale(folder, jid + "_s.png", input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readJidSmallPhoto(String jid) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            return FileUtil.readFileHandleExif(folder, jid + "_s.png");
        }
    }

    public static boolean existJidSmallPhoto(String jid) {
        File folder = FileUtil.getPhotoRoot();
        File f = new File(folder, jid + "_s.png");
        return f.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteJidSmallPhoto(String jid) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            FileUtil.deleteFileLocale(folder, jid + "_s.png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJidBigPhoto(String jid, InputStream input) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            FileUtil.writeFileLocale(folder, jid + "_b.png", input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readJidBigPhoto(String jid) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            return FileUtil.readFileHandleExif(folder, jid + "_b.png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteJidBigPhoto(String jid) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            FileUtil.deleteFileLocale(folder, jid + "_b.png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeContactSmallPhoto(long id, InputStream input) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            FileUtil.writeFileLocale(folder, "mycontact_" + id + "_s.png", input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readContactSmallPhoto(long id) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            return FileUtil.readFileHandleExif(folder, "mycontact_" + id + "_s.png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteContactSmallPhoto(long id) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            FileUtil.deleteFileLocale(folder, "mycontact_" + id + "_s.png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeContactBigPhoto(long id, InputStream input) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            FileUtil.writeFileLocale(folder, "mycontact_" + id + "_b.png", input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readContactBigPhoto(long id) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            return FileUtil.readFileHandleExif(folder, "mycontact_" + id + "_b.png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteContactBigPhoto(long id) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            FileUtil.deleteFileLocale(folder, "mycontact_" + id + "_b.png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLogoBigPhoto(InputStream input) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getLogoPhotoRoot();
            FileUtil.writeFileLocale(folder, "logo_b.png", input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readLogoBigPhoto() {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getLogoPhotoRoot();
            return FileUtil.readFileHandleExif(folder, "logo_b.png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLogoBigPhoto() {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getLogoPhotoRoot();
            FileUtil.deleteFileLocale(folder, "logo_b.png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLogoSmallPhoto(InputStream input) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getLogoPhotoRoot();
            FileUtil.writeFileLocale(folder, "logo_s.png", input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readLogoSmallPhoto() {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getLogoPhotoRoot();
            return FileUtil.readFileHandleExif(folder, "logo_s.png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLogoSmallPhoto() {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getLogoPhotoRoot();
            FileUtil.deleteFileLocale(folder, "logo_s.png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRegistrationBackgtoundFile(InputStream input) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getLogoPhotoRoot();
            FileUtil.writeFileLocale(folder, "reg_background.png", input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readRegistrationBackgtoundFile() {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getLogoPhotoRoot();
            return FileUtil.readFileHandleExif(folder, "reg_background.png");
        }
    }

    public static boolean existRegistrationBackgtoundFile() {
        File folder = FileUtil.getLogoPhotoRoot();
        if (!folder.exists()) {
            Log.w(FileUtil.class.getSimpleName(), "read file fail!: folder not found" + folder.getAbsolutePath());
            return false;
        }
        File file = new File(folder, "reg_background.png");
        if (!file.exists()) {
            Log.w(FileUtil.class.getSimpleName(), "read file fail!: file not found" + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRegistrationBackgtoundFile() {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getLogoPhotoRoot();
            FileUtil.deleteFileLocale(folder, "reg_background.png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRegistrationLogoFile(InputStream input) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getLogoPhotoRoot();
            FileUtil.writeFileLocale(folder, "reg_logo.png", input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readRegistrationLogoFile() {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getLogoPhotoRoot();
            return FileUtil.readFileHandleExif(folder, "reg_logo.png");
        }
    }

    public static boolean existRegistrationLogoFile() {
        File folder = FileUtil.getLogoPhotoRoot();
        if (!folder.exists()) {
            Log.w(FileUtil.class.getSimpleName(), "read file fail!: folder not found" + folder.getAbsolutePath());
            return false;
        }
        File file = new File(folder, "reg_logo.png");
        if (!file.exists()) {
            Log.w(FileUtil.class.getSimpleName(), "read file fail!: file not found" + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRegistrationLogoFile() {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getLogoPhotoRoot();
            FileUtil.deleteFileLocale(folder, "reg_logo.png");
        }
    }

    private static String getBulletinSubjectPhotoName(long bulletinId) {
        return BULLETIN_PREFIX_ + bulletinId + "_subject.png";
    }

    public static boolean existBulletinSubjectPhoto(long bulletinId) {
        File folder = FileUtil.getPhotoRoot();
        File f = new File(folder, FileUtil.getBulletinSubjectPhotoName(bulletinId));
        return f.exists();
    }

    public static File getBulletinSubjectPhoto(long bulletinId) {
        File folder = FileUtil.getPhotoRoot();
        File f = new File(folder, FileUtil.getBulletinSubjectPhotoName(bulletinId));
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBulletinSubjectPhoto(long bulletinId, InputStream input) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            FileUtil.writeFileLocale(folder, FileUtil.getBulletinSubjectPhotoName(bulletinId), input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readBulletinSubjectPhoto(long bulletinId) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            return FileUtil.readFileHandleExif(folder, FileUtil.getBulletinSubjectPhotoName(bulletinId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteBulletinSubjectPhoto(long bulletinId) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            FileUtil.deleteFileLocale(folder, FileUtil.getBulletinSubjectPhotoName(bulletinId));
        }
    }

    public static File getBulletinAttachmentRoot() {
        File root = FileUtil.getExternalFileRoot();
        File folder = new File(root, BULLETIN_ATTACHMENT_FOLDER);
        FileUtil.checkAndCreate(folder);
        return folder;
    }

    public static boolean existBulletinAttachment(long bulletinId, int index) {
        File attachRoot = FileUtil.getBulletinAttachmentRoot();
        File f = new File(attachRoot, BULLETIN_PREFIX_ + bulletinId + "_" + index);
        return f.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteBulletinAttachment(long bulletinId, int index) {
        Object object = lock;
        synchronized (object) {
            File attachRoot = FileUtil.getBulletinAttachmentRoot();
            FileUtil.deleteFileLocale(attachRoot, BULLETIN_PREFIX_ + bulletinId + "_" + index);
        }
    }

    public static File getBulletinAttachment(long bulletinId, int index) {
        File attachRoot = FileUtil.getBulletinAttachmentRoot();
        return new File(attachRoot, BULLETIN_PREFIX_ + bulletinId + "_" + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanBulletinAttachment() {
        Object object = lock;
        synchronized (object) {
            File attachRoot = FileUtil.getBulletinAttachmentRoot();
            FileUtil.deleteDirectory(attachRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMessageChannelPhoto(long channelId, InputStream input) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            FileUtil.writeFileLocale(folder, "msg_channel_" + channelId + ".png", input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readMessageChannelPhoto(long channelId) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            return FileUtil.readFileHandleExif(folder, "msg_channel_" + channelId + ".png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteMessageChannelPhoto(long channelId) {
        Object object = lock;
        synchronized (object) {
            File folder = FileUtil.getPhotoRoot();
            FileUtil.deleteFileLocale(folder, "msg_channel_" + channelId + ".png");
        }
    }

    public static boolean contentEquals(File file1, File file2) throws IOException {
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            throw new IOException("Can't compare directories, only files");
        }
        if (file1.length() != file2.length()) {
            return false;
        }
        if (file1.getCanonicalFile().equals(file2.getCanonicalFile())) {
            return true;
        }
        try (FileInputStream input1 = new FileInputStream(file1);){
            boolean bl;
            try (FileInputStream input2 = new FileInputStream(file2);){
                bl = FileUtil.contentEquals(input1, input2);
            }
            return bl;
        }
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        if (input1 == input2) {
            return true;
        }
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }
}

