/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.util;

import com.blisscloud.ezuc.client.util.TextUtils;

public class JidUtil {
    public static final String EXTERNAL_CALL_FAKE_JID = "__EXTERNAL_TRUNK_CALL_GROUP__";
    public static final String FAX_DOC_FAKE_JID = "__FAX_DOC_GROUP__";
    public static final String BLISS_BASE_JID_SUFFIX = "@blisscloud.com";
    public static final String SOCIAL_JID_SUFFIX = "@social.blisscloud.com";
    public static final String API_USER_JID_SUFFIX = "@apiuser.blisscloud.com";
    public static final String RINGGROUP_JID_SUFFIX = "@ringgroup.blisscloud.com";

    public static boolean isFakeExternalCallJid(String jid) {
        if (jid == null) {
            return false;
        }
        return EXTERNAL_CALL_FAKE_JID.equals(jid);
    }

    public static boolean isFakeFaxDocJid(String jid) {
        if (jid == null) {
            return false;
        }
        return FAX_DOC_FAKE_JID.equals(jid);
    }

    public static boolean isEmployeeJid(String jid) {
        return !JidUtil.isFakeExternalCallJid(jid) && !JidUtil.isFakeFaxDocJid(jid) && !JidUtil.isRingGroupJid(jid) && !JidUtil.isNotEmpPattern(jid) && !JidUtil.isChatConfJid(jid) && !JidUtil.isLocationJid(jid) && !JidUtil.isMobileContactJid(jid) && !JidUtil.isMyContactJid(jid) && !JidUtil.isCustomerJid(jid) && !JidUtil.isBcAnnouncerJid(jid) && !JidUtil.isAPIUserJid(jid) && !JidUtil.isPhoneNumberJid(jid) && !JidUtil.isPhoneNumberJid2(jid) && !JidUtil.isPhoneNumberOld(jid);
    }

    public static boolean isRingGroupJid(String jid) {
        if (jid == null) {
            return false;
        }
        return jid.endsWith(RINGGROUP_JID_SUFFIX);
    }

    public static boolean isNotEmpPattern(String jid) {
        if (jid == null) {
            return false;
        }
        return jid.indexOf(64) < 0;
    }

    public static boolean isPhoneNumberOld(String jid) {
        if (jid == null) {
            return false;
        }
        String[] keys = jid.split("@@");
        return keys.length == 2 && keys[0] != null && keys[0].equals("__NUMBER__");
    }

    public static boolean isPhoneNumberJid(String jid) {
        if (jid == null) {
            return false;
        }
        return jid.endsWith("@phonenumber");
    }

    public static boolean isPhoneNumberJid2(String jid) {
        String[] keys;
        if (jid == null) {
            return false;
        }
        return jid.contains("_@@_") && (keys = jid.split("_@@_")) != null && keys.length == 2;
    }

    public static boolean isBcAnnouncerJid(String jid) {
        if (jid == null) {
            return false;
        }
        return "bc_announcer_blisscloud@blisscloud.com".equalsIgnoreCase(jid);
    }

    public static boolean isAPI000001UserJid(String jid) {
        if (jid == null) {
            return false;
        }
        return "__api_user__000001@blisscloud.com".equalsIgnoreCase(jid) || "__api_user__000001@apiuser.blisscloud.com".equalsIgnoreCase(jid);
    }

    public static boolean isAPIUserJid(String jid) {
        if (jid == null) {
            return false;
        }
        if (jid.endsWith(API_USER_JID_SUFFIX)) {
            return true;
        }
        return jid.startsWith("__api_user__");
    }

    public static boolean isMyContactJid(String jid) {
        if (jid == null) {
            return false;
        }
        return jid.endsWith("@externalcontact");
    }

    public static boolean isMobileContactJid(String jid) {
        if (jid == null) {
            return false;
        }
        return jid.endsWith("@mobilecontact");
    }

    public static boolean isChatConfJid(String jid) {
        return JidUtil.isChatJid(jid) || JidUtil.isConfJid(jid);
    }

    public static boolean isChatJid(String jid) {
        if (jid == null) {
            return false;
        }
        return jid.startsWith("chatroom_");
    }

    public static boolean isConfJid(String jid) {
        if (jid == null) {
            return false;
        }
        return jid.startsWith("conferenceroom_");
    }

    public static boolean isLocationJid(String jid) {
        if (jid == null) {
            return false;
        }
        return jid.indexOf("@location.") != -1;
    }

    public static boolean isCustomerJid(String jid) {
        if (jid == null) {
            return false;
        }
        if (jid.endsWith(SOCIAL_JID_SUFFIX)) {
            return true;
        }
        return jid.startsWith("wechat_") || jid.startsWith("__customer__");
    }

    public static long trimExternalContactId(String jid) {
        String tmp;
        long id = -1L;
        if (jid == null) {
            return id;
        }
        if (jid.indexOf("@externalcontact") > -1 && TextUtils.isDigitsOnly(tmp = jid.substring(0, jid.indexOf("@externalcontact")))) {
            id = Long.parseLong(tmp);
        }
        return id;
    }

    public static long trimMobileContactId(String jid) {
        String tmp;
        long id = -1L;
        if (jid == null) {
            return id;
        }
        if (jid.indexOf("@mobilecontact") > -1 && TextUtils.isDigitsOnly(tmp = jid.substring(0, jid.indexOf("@mobilecontact")))) {
            id = Long.parseLong(tmp);
        }
        return id;
    }

    public static String trimPhoneNumberOld(String fromJid) {
        if (fromJid == null) {
            return "NA";
        }
        String[] keys = fromJid.split("@@");
        if (keys.length == 2 && keys[0] != null && keys[0].equals("__NUMBER__")) {
            return keys[1];
        }
        return "NA";
    }

    public static String trimPhoneNumber(String jid) {
        if (jid == null) {
            return "NA";
        }
        if (jid.indexOf("@phonenumber") > -1) {
            return jid.substring(0, jid.indexOf("@phonenumber"));
        }
        return "NA";
    }

    public static String getJidName(String jid) {
        if (jid == null) {
            return "";
        }
        int index = jid.indexOf("@");
        if (index == -1) {
            return jid;
        }
        String prefix = jid.substring(0, index);
        int index2 = prefix.indexOf("_");
        if (index2 == -1) {
            return prefix;
        }
        return jid.substring(0, index2);
    }

    public static String convertKey(String key) {
        if (key == null) {
            return key;
        }
        if (!key.contains("@")) {
            return key;
        }
        String[] sp = key.split("@");
        return sp[0];
    }

    public static String jidTranslate(String fromJID) {
        if (JidUtil.isAPIUserJid(fromJID)) {
            if (fromJID.endsWith(BLISS_BASE_JID_SUFFIX)) {
                return JidUtil.convertKey(fromJID) + API_USER_JID_SUFFIX;
            }
        } else if (JidUtil.isCustomerJid(fromJID) && fromJID.endsWith(BLISS_BASE_JID_SUFFIX)) {
            return JidUtil.convertKey(fromJID) + SOCIAL_JID_SUFFIX;
        }
        return fromJID;
    }
}

