/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.util;

import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.HttpRequestUtil;
import com.blisscloud.mobile.ezuc.util.ICheckCompleteListener;
import com.blisscloud.mobile.ezuc.util.UCDSUtil;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;

public abstract class RequestHelperBase
implements HttpRequestUtil.IRequestListener {
    public static final int RESULT_OK = 0;
    public static final int RESULT_CONNECTIONERROR = 1;
    public static final int RESULT_INPUTERROR = 2;
    private final String mEnterpriseNo;
    private final String mSuffixUrl;
    private final String mBaseUrl;
    private final Context mCtx;
    private final ICheckCompleteListener mListener;
    private HashMap<String, String> mParameter;
    private JSONObject mJo;
    private HttpRequestUtil mRequest;
    private List<String> mIPList;
    private int mIndex;
    private boolean mHandleRedirect;

    public RequestHelperBase(Context ctx, String enterpriseNo, String baseUrl, String suffixUrl, JSONObject jo, HashMap<String, String> paramter, ICheckCompleteListener listener, boolean handleRedirect) {
        this.mEnterpriseNo = enterpriseNo;
        this.mCtx = ctx;
        this.mListener = listener;
        this.mIPList = UCDSUtil.getServerIpList(ctx);
        this.mIndex = -1;
        this.mJo = jo;
        this.mParameter = paramter;
        if (this.mIPList != null && this.mIPList.size() > 0) {
            this.mIndex = 0;
        }
        this.mSuffixUrl = suffixUrl;
        this.mBaseUrl = baseUrl;
        this.mHandleRedirect = handleRedirect;
        this.doCheck();
    }

    public boolean doCheck() {
        Log.i(this.getClass().getSimpleName(), "Fetch enterprise info now ...");
        String ip = null;
        boolean start = false;
        if (this.mIndex >= 0 && this.mIndex < this.mIPList.size()) {
            try {
                ip = this.mIPList.get(this.mIndex);
                ++this.mIndex;
                String url = String.format(this.mBaseUrl, ip) + this.mSuffixUrl;
                Log.i(this.getClass().getSimpleName(), "Fetch enterprise info now ...ip:" + ip + ",  url=" + url + ", mIndex:" + (this.mIndex - 1));
                this.mRequest = new HttpRequestUtil(this.mCtx, this.mEnterpriseNo, url, this.mJo, this.mParameter, this, this.mHandleRedirect, 10000);
                this.mRequest.execute(new Void[0]);
                start = true;
            }
            catch (Throwable e) {
                Log.e(this.getClass().getSimpleName(), "doCheck", e);
            }
        }
        return start;
    }

    public void terminate() {
        this.mRequest.cancel(true);
    }

    public HttpRequestUtil getRequest() {
        return this.mRequest;
    }

    public void setRequest(HttpRequestUtil request) {
        this.mRequest = request;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public void setIndex(int index) {
        this.mIndex = index;
    }

    public String getEnterpriseNo() {
        return this.mEnterpriseNo;
    }

    public Context getCtx() {
        return this.mCtx;
    }

    public ICheckCompleteListener getListener() {
        return this.mListener;
    }

    public HashMap<String, String> getParameter() {
        return this.mParameter;
    }

    public JSONObject getJo() {
        return this.mJo;
    }

    public void setParameter(HashMap<String, String> parameter) {
        this.mParameter = parameter;
    }

    public void setJo(JSONObject jo) {
        this.mJo = jo;
    }
}

