/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.util;

import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public class UCDSUtil {
    public static final String CHINA_UCDS_DOMAIN = "ucds.miraclephone.cn:443";
    public static final String TAIPEI_UCDS_DOMAIN = "ucds.blisscloud.com:443";
    public static final String TAIPEI_UCDS_TP_DOMAIN = "ucds-tp.blisscloud.com:443";
    public static final String UCDS_SERVERLIST = "[\"ucds.blisscloud.com:443\",\"ucds-tp.blisscloud.com:443\",\"ucds.miraclephone.cn:443\"]";

    public static void updateServerIpList(Context ctx, String ipListStr) {
        PreferencesUtil.putString(ctx, "SERVERIPLIST_20230414", ipListStr);
    }

    public static List<String> getServerIpList(Context ctx) {
        String ipListStr = PreferencesUtil.getString(ctx, "SERVERIPLIST_20230414", UCDS_SERVERLIST);
        JSONArray ipList = null;
        if (TextUtils.isNotBlank((CharSequence)ipListStr)) {
            try {
                ipList = new JSONArray(ipListStr);
            }
            catch (JSONException e) {
                Log.e(UCDSUtil.class.getSimpleName(), "CheckEnterpriseTask ip list is error:" + ipListStr);
            }
        }
        ArrayList<String> originalList = new ArrayList<String>();
        if (ipList != null) {
            for (int i = 0; i < ipList.length(); ++i) {
                try {
                    String ip = (String)ipList.get(i);
                    originalList.add(ip);
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        ArrayList<String> targetList = new ArrayList<String>();
        ArrayList<String> restList = new ArrayList<String>();
        if (CommonUtil.isChina(ctx)) {
            for (String ip : originalList) {
                if (ip.equalsIgnoreCase(CHINA_UCDS_DOMAIN)) {
                    targetList.add(ip);
                    continue;
                }
                restList.add(ip);
            }
        } else {
            for (String ip : originalList) {
                if (ip.equalsIgnoreCase(TAIPEI_UCDS_DOMAIN) || ip.equalsIgnoreCase(TAIPEI_UCDS_TP_DOMAIN)) {
                    targetList.add(ip);
                    continue;
                }
                restList.add(ip);
            }
        }
        targetList.addAll(restList);
        return targetList;
    }
}

