/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.SocketChannelIOHelper;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketAdapter;
import org.java_websocket.WebSocketFactory;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.WrappedByteChannel;
import org.java_websocket.client.AbstractClientProxyChannel;
import org.java_websocket.client.DefaultWebSocketClientFactory;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_10;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.exceptions.InvalidFrameException;
import org.java_websocket.exceptions.InvalidHandshakeException;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.HandshakeImpl1Client;
import org.java_websocket.handshake.Handshakedata;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.util.Charsetfunctions;

public abstract class WebSocketClient
extends WebSocketAdapter
implements Runnable {
    protected URI uri = null;
    private WebSocketImpl conn = null;
    private SocketChannel channel = null;
    private ByteChannel wrappedchannel = null;
    private Thread writethread;
    private Thread readthread;
    private Draft draft;
    private Map<String, String> headers;
    private CountDownLatch connectLatch = new CountDownLatch(1);
    private CountDownLatch closeLatch = new CountDownLatch(1);
    private int timeout = 0;
    private WebSocketClientFactory wsfactory = new DefaultWebSocketClientFactory(this);
    private InetSocketAddress proxyAddress = null;
    private Framedata tempFramedata = null;

    public WebSocketClient(URI serverURI) {
        this(serverURI, new Draft_10());
    }

    public WebSocketClient(URI serverUri, Draft draft) {
        this(serverUri, draft, null, 0);
    }

    public WebSocketClient(URI serverUri, Draft draft, Map<String, String> headers) {
        this(serverUri, draft, headers, 0);
    }

    public WebSocketClient(URI serverUri, Draft draft, Map<String, String> headers, int connecttimeout) {
        if (serverUri == null) {
            throw new IllegalArgumentException();
        }
        if (draft == null) {
            throw new IllegalArgumentException("null as draft is permitted for `WebSocketServer` only!");
        }
        this.uri = serverUri;
        this.draft = draft;
        this.headers = headers;
        this.timeout = connecttimeout;
        try {
            this.channel = SelectorProvider.provider().openSocketChannel();
            this.channel.configureBlocking(true);
        }
        catch (IOException e) {
            this.channel = null;
            this.onWebsocketError(null, e);
        }
        if (this.channel == null) {
            this.conn = (WebSocketImpl)this.wsfactory.createWebSocket((WebSocketAdapter)this, draft, null);
            this.conn.close(-1, "Failed to create or configure SocketChannel.");
        } else {
            this.conn = (WebSocketImpl)this.wsfactory.createWebSocket((WebSocketAdapter)this, draft, this.channel.socket());
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public Draft getDraft() {
        return this.draft;
    }

    public void connect() {
        if (this.writethread != null) {
            throw new IllegalStateException("WebSocketClient objects are not reuseable");
        }
        this.writethread = new Thread(this);
        this.writethread.start();
    }

    public boolean connectBlocking() throws InterruptedException {
        this.connect();
        this.connectLatch.await();
        return this.conn.isOpen();
    }

    public void close() {
        if (this.writethread != null) {
            this.conn.close(1000);
        }
    }

    public void closeBlocking() throws InterruptedException {
        this.close();
        this.closeLatch.await();
    }

    public void send(String text) throws NotYetConnectedException {
        this.conn.send(text);
    }

    public void send(byte[] data) throws NotYetConnectedException {
        this.conn.send(data);
    }

    @Override
    public void run() {
        if (this.writethread == null) {
            this.writethread = Thread.currentThread();
        }
        this.interruptableRun();
        assert (!this.channel.isOpen());
    }

    private final void interruptableRun() {
        if (this.channel == null) {
            return;
        }
        try {
            int port;
            String host;
            if (this.proxyAddress != null) {
                host = this.proxyAddress.getHostName();
                port = this.proxyAddress.getPort();
            } else {
                host = this.uri.getHost();
                port = this.getPort();
            }
            this.channel.connect(new InetSocketAddress(host, port));
            this.conn.channel = this.wrappedchannel = this.createProxyChannel(this.wsfactory.wrapChannel(this.channel, null, host, port));
            this.timeout = 0;
            this.sendHandshake();
            this.readthread = new Thread(new WebsocketWriteThread());
            this.readthread.start();
        }
        catch (ClosedByInterruptException e) {
            this.onWebsocketError(null, e);
            return;
        }
        catch (Exception e) {
            this.onWebsocketError(this.conn, e);
            this.conn.closeConnection(-1, e.getMessage());
            return;
        }
        ByteBuffer buff = ByteBuffer.allocate(WebSocketImpl.RCVBUF);
        try {
            while (this.channel.isOpen()) {
                WrappedByteChannel w;
                if (SocketChannelIOHelper.read(buff, this.conn, this.wrappedchannel)) {
                    this.conn.decode(buff);
                } else {
                    this.conn.eot();
                }
                if (!(this.wrappedchannel instanceof WrappedByteChannel) || !(w = (WrappedByteChannel)this.wrappedchannel).isNeedRead()) continue;
                while (this.channel.isOpen() && SocketChannelIOHelper.readMore(buff, this.conn, w)) {
                    this.conn.decode(buff);
                }
                this.conn.decode(buff);
            }
        }
        catch (CancelledKeyException e) {
            this.conn.eot();
        }
        catch (IOException e) {
            this.conn.eot();
        }
        catch (RuntimeException e) {
            this.onError(e);
            this.conn.closeConnection(1006, e.getMessage());
        }
    }

    private int getPort() {
        int port = this.uri.getPort();
        if (port == -1) {
            String scheme = this.uri.getScheme();
            if (scheme.equals("wss")) {
                return 443;
            }
            if (scheme.equals("ws")) {
                return 80;
            }
            throw new RuntimeException("unkonow scheme" + scheme);
        }
        return port;
    }

    private void sendHandshake() throws InvalidHandshakeException {
        String part1 = this.uri.getPath();
        String part2 = this.uri.getQuery();
        Object path = part1 == null || part1.length() == 0 ? "/" : part1;
        if (part2 != null) {
            path = (String)path + "?" + part2;
        }
        int port = this.getPort();
        String host = this.uri.getHost() + (String)(port != 80 ? ":" + port : "");
        HandshakeImpl1Client handshake = new HandshakeImpl1Client();
        handshake.setResourceDescriptor((String)path);
        handshake.put("Host", host);
        if (this.headers != null) {
            for (Map.Entry<String, String> kv : this.headers.entrySet()) {
                handshake.put(kv.getKey(), kv.getValue());
            }
        }
        this.conn.startHandshake(handshake);
    }

    public WebSocket.READYSTATE getReadyState() {
        return this.conn.getReadyState();
    }

    @Override
    public final void onWebsocketMessage(WebSocket conn, String message) {
        this.onMessage(message);
    }

    @Override
    public final void onWebsocketMessage(WebSocket conn, ByteBuffer blob) {
        this.onMessage(blob);
    }

    @Override
    public final void onWebsocketMessageFragment(WebSocket conn, Framedata frame) {
        Framedata.Opcode opcode = frame.getOpcode();
        if (opcode == Framedata.Opcode.TEXT || opcode == Framedata.Opcode.BINARY) {
            this.tempFramedata = frame;
        } else if (opcode == Framedata.Opcode.CONTINUOUS) {
            try {
                this.tempFramedata.append(frame);
            }
            catch (InvalidFrameException e) {
                e.printStackTrace();
            }
            if (frame.isFin()) {
                Framedata.Opcode tempOpcode = this.tempFramedata.getOpcode();
                if (tempOpcode == Framedata.Opcode.TEXT) {
                    try {
                        this.onMessage(Charsetfunctions.stringUtf8(this.tempFramedata.getPayloadData()));
                    }
                    catch (InvalidDataException e) {
                        e.printStackTrace();
                    }
                } else if (tempOpcode == Framedata.Opcode.BINARY) {
                    this.onMessage(this.tempFramedata.getPayloadData());
                }
                this.tempFramedata = null;
            }
        }
    }

    @Override
    public final void onWebsocketOpen(WebSocket conn, Handshakedata handshake) {
        this.connectLatch.countDown();
        this.onOpen((ServerHandshake)handshake);
    }

    @Override
    public final void onWebsocketClose(WebSocket conn, int code, String reason, boolean remote) {
        this.connectLatch.countDown();
        this.closeLatch.countDown();
        if (this.readthread != null) {
            this.readthread.interrupt();
        }
        this.onClose(code, reason, remote);
    }

    @Override
    public final void onWebsocketError(WebSocket conn, Exception ex) {
        this.onError(ex);
    }

    @Override
    public final void onWriteDemand(WebSocket conn) {
    }

    @Override
    public void onWebsocketCloseInitiated(WebSocket conn, int code, String reason) {
        this.onCloseInitiated(code, reason);
    }

    @Override
    public void onWebsocketClosing(WebSocket conn, int code, String reason, boolean remote) {
        this.onClosing(code, reason, remote);
    }

    public void onCloseInitiated(int code, String reason) {
    }

    public void onClosing(int code, String reason, boolean remote) {
    }

    public WebSocket getConnection() {
        return this.conn;
    }

    public final void setWebSocketFactory(WebSocketClientFactory wsf) {
        this.wsfactory = wsf;
    }

    public final WebSocketFactory getWebSocketFactory() {
        return this.wsfactory;
    }

    @Override
    public InetSocketAddress getLocalSocketAddress(WebSocket conn) {
        if (this.channel != null) {
            return (InetSocketAddress)this.channel.socket().getLocalSocketAddress();
        }
        return null;
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress(WebSocket conn) {
        if (this.channel != null) {
            return (InetSocketAddress)this.channel.socket().getLocalSocketAddress();
        }
        return null;
    }

    public abstract void onOpen(ServerHandshake var1);

    public abstract void onMessage(String var1);

    public abstract void onClose(int var1, String var2, boolean var3);

    public abstract void onError(Exception var1);

    public void onMessage(ByteBuffer bytes) {
    }

    public ByteChannel createProxyChannel(ByteChannel towrap) {
        if (this.proxyAddress != null) {
            return new DefaultClientProxyChannel(towrap);
        }
        return towrap;
    }

    public void setProxy(InetSocketAddress proxyaddress) {
        this.proxyAddress = proxyaddress;
    }

    public static interface WebSocketClientFactory
    extends WebSocketFactory {
        public ByteChannel wrapChannel(SocketChannel var1, SelectionKey var2, String var3, int var4) throws IOException;
    }

    private class WebsocketWriteThread
    implements Runnable {
        private WebsocketWriteThread() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("WebsocketWriteThread");
            try {
                while (!Thread.interrupted()) {
                    SocketChannelIOHelper.writeBlocking(WebSocketClient.this.conn, WebSocketClient.this.wrappedchannel);
                }
            }
            catch (IOException e) {
                WebSocketClient.this.conn.eot();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public class DefaultClientProxyChannel
    extends AbstractClientProxyChannel {
        public DefaultClientProxyChannel(ByteChannel towrap) {
            super(towrap);
        }

        @Override
        public String buildHandShake() {
            StringBuilder b = new StringBuilder();
            String host = WebSocketClient.this.uri.getHost();
            b.append("CONNECT ");
            b.append(host);
            b.append(":");
            b.append(WebSocketClient.this.getPort());
            b.append(" HTTP/1.1\n");
            b.append("Host: ");
            b.append(host);
            b.append("\n");
            return b.toString();
        }
    }
}

