/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.scale;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.scale.ColorUtil;
import org.jcodec.scale.RgbToBgr;
import org.jcodec.scale.Transform;

public class AWTUtil {
    private static final int alphaR = 255;
    private static final int alphaG = 255;
    private static final int alphaB = 255;

    public static void toBufferedImage2(Picture src, BufferedImage dst) {
        byte[] data = ((DataBufferByte)dst.getRaster().getDataBuffer()).getData();
        byte[] srcData = src.getPlaneData(0);
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(srcData[i] + 128);
        }
    }

    public static BufferedImage toBufferedImage(Picture src) {
        if (src.getColor() != ColorSpace.BGR) {
            Picture bgr = Picture.createCropped(src.getWidth(), src.getHeight(), ColorSpace.BGR, src.getCrop());
            if (src.getColor() == ColorSpace.RGB) {
                new RgbToBgr().transform(src, bgr);
            } else {
                Transform transform = ColorUtil.getTransform(src.getColor(), ColorSpace.RGB);
                transform.transform(src, bgr);
                new RgbToBgr().transform(bgr, bgr);
            }
            src = bgr;
        }
        BufferedImage dst = new BufferedImage(src.getCroppedWidth(), src.getCroppedHeight(), 5);
        if (src.getCrop() == null) {
            AWTUtil.toBufferedImage2(src, dst);
        } else {
            AWTUtil.toBufferedImageCropped(src, dst);
        }
        return dst;
    }

    private static void toBufferedImageCropped(Picture src, BufferedImage dst) {
        byte[] data = ((DataBufferByte)dst.getRaster().getDataBuffer()).getData();
        byte[] srcData = src.getPlaneData(0);
        int dstStride = dst.getWidth() * 3;
        int srcStride = src.getWidth() * 3;
        int srcOff = 0;
        int dstOff = 0;
        for (int line = 0; line < dst.getHeight(); ++line) {
            int id = dstOff;
            int is = srcOff;
            while (id < dstOff + dstStride) {
                data[id] = (byte)(srcData[is] + 128);
                data[id + 1] = (byte)(srcData[is + 1] + 128);
                data[id + 2] = (byte)(srcData[is + 2] + 128);
                id += 3;
                is += 3;
            }
            srcOff += srcStride;
            dstOff += dstStride;
        }
    }

    public static Picture fromBufferedImage(BufferedImage src, ColorSpace tgtColor) {
        Picture rgb = AWTUtil.fromBufferedImageRGB(src);
        Transform tr = ColorUtil.getTransform(rgb.getColor(), tgtColor);
        Picture res = Picture.create(rgb.getWidth(), rgb.getHeight(), tgtColor);
        tr.transform(rgb, res);
        return res;
    }

    public static Picture fromBufferedImageRGB(BufferedImage src) {
        Picture dst = Picture.create(src.getWidth(), src.getHeight(), ColorSpace.RGB);
        AWTUtil.fromBufferedImage(src, dst);
        return dst;
    }

    public static void fromBufferedImage(BufferedImage src, Picture dst) {
        byte[] dstData = dst.getPlaneData(0);
        int off = 0;
        for (int i = 0; i < src.getHeight(); ++i) {
            for (int j = 0; j < src.getWidth(); ++j) {
                int rgb1 = src.getRGB(j, i);
                int alpha = rgb1 >> 24 & 0xFF;
                if (alpha == 255) {
                    dstData[off++] = (byte)((rgb1 >> 16 & 0xFF) - 128);
                    dstData[off++] = (byte)((rgb1 >> 8 & 0xFF) - 128);
                    dstData[off++] = (byte)((rgb1 & 0xFF) - 128);
                    continue;
                }
                int nalpha = 255 - alpha;
                dstData[off++] = (byte)(((rgb1 >> 16 & 0xFF) * alpha + 255 * nalpha >> 8) - 128);
                dstData[off++] = (byte)(((rgb1 >> 8 & 0xFF) * alpha + 255 * nalpha >> 8) - 128);
                dstData[off++] = (byte)(((rgb1 & 0xFF) * alpha + 255 * nalpha >> 8) - 128);
            }
        }
    }
}

