/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.protocol;

import java.io.IOException;
import java.util.Vector;
import javax.media.Time;
import javax.media.protocol.DataSource;
import javax.media.protocol.SourceStream;

class MergingDataSource
extends DataSource {
    DataSource[] sources;
    SourceStream[] streams = null;
    Object[] controls = null;

    MergingDataSource(DataSource[] sources) {
        this.sources = sources;
    }

    public String getContentType() {
        if (this.sources.length == 1) {
            return this.sources[0].getContentType();
        }
        boolean isRaw = true;
        int index = 0;
        while (index < this.sources.length) {
            if (!this.sources[index].getContentType().equals("raw")) {
                isRaw = false;
                break;
            }
            ++index;
        }
        if (isRaw) {
            return "raw";
        }
        if (this.sources.length == 1) {
            return this.sources[0].getContentType();
        }
        return "application.mixed-data";
    }

    public void connect() throws IOException {
        int i2 = 0;
        while (i2 < this.sources.length) {
            this.sources[i2].connect();
            ++i2;
        }
    }

    public void disconnect() {
        int i2 = 0;
        while (i2 < this.sources.length) {
            this.sources[i2].disconnect();
            ++i2;
        }
    }

    public void start() throws IOException {
        int i2 = 0;
        while (i2 < this.sources.length) {
            this.sources[i2].start();
            ++i2;
        }
    }

    public void stop() throws IOException {
        int i2 = 0;
        while (i2 < this.sources.length) {
            this.sources[i2].stop();
            ++i2;
        }
    }

    public Object[] getControls() {
        if (this.controls == null) {
            Vector<Object> vcontrols = new Vector<Object>(1);
            int i2 = 0;
            while (i2 < this.sources.length) {
                Object[] cs = this.sources[i2].getControls();
                if (cs.length > 0) {
                    int j2 = 0;
                    while (j2 < cs.length) {
                        vcontrols.addElement(cs[j2]);
                        ++j2;
                    }
                }
                ++i2;
            }
            this.controls = new Object[vcontrols.size()];
            int c2 = 0;
            while (c2 < vcontrols.size()) {
                this.controls[c2] = vcontrols.elementAt(c2);
                ++c2;
            }
        }
        return this.controls;
    }

    public Object getControl(String controlType) {
        try {
            Class<?> cls = Class.forName(controlType);
            Object[] cs = this.getControls();
            int i2 = 0;
            while (i2 < cs.length) {
                if (cls.isInstance(cs[i2])) {
                    return cs[i2];
                }
                ++i2;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public Time getDuration() {
        Time longest = new Time(0L);
        int i2 = 0;
        while (i2 < this.sources.length) {
            Time sourceDuration = this.sources[i2].getDuration();
            if (sourceDuration.getSeconds() > longest.getSeconds()) {
                longest = sourceDuration;
            }
            ++i2;
        }
        return longest;
    }
}

