/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.png;

import com.drew.imaging.png.PngChromaticities;
import com.drew.imaging.png.PngChunk;
import com.drew.imaging.png.PngChunkReader;
import com.drew.imaging.png.PngChunkType;
import com.drew.imaging.png.PngHeader;
import com.drew.imaging.png.PngProcessingException;
import com.drew.lang.ByteConvert;
import com.drew.lang.DateUtil;
import com.drew.lang.KeyValuePair;
import com.drew.lang.RandomAccessStreamReader;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.StreamReader;
import com.drew.lang.StringUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.file.FileMetadataReader;
import com.drew.metadata.icc.IccReader;
import com.drew.metadata.png.PngChromaticitiesDirectory;
import com.drew.metadata.png.PngDirectory;
import com.drew.metadata.xmp.XmpReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.InflaterInputStream;

public class PngMetadataReader {
    private static Set<PngChunkType> _desiredChunkTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws PngProcessingException, IOException {
        Metadata metadata;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            metadata = PngMetadataReader.readMetadata(fileInputStream);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        new FileMetadataReader().read(file, metadata);
        return metadata;
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) throws PngProcessingException, IOException {
        Iterable<PngChunk> iterable = new PngChunkReader().extract(new StreamReader(inputStream), _desiredChunkTypes);
        Metadata metadata = new Metadata();
        for (PngChunk pngChunk : iterable) {
            try {
                PngMetadataReader.processChunk(metadata, pngChunk);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        return metadata;
    }

    private static void processChunk(@NotNull Metadata metadata, @NotNull PngChunk pngChunk) throws PngProcessingException, IOException {
        PngChunkType pngChunkType = pngChunk.getType();
        byte[] byArray = pngChunk.getBytes();
        if (pngChunkType.equals(PngChunkType.IHDR)) {
            PngHeader pngHeader = new PngHeader(byArray);
            PngDirectory pngDirectory = new PngDirectory(PngChunkType.IHDR);
            pngDirectory.setInt(1, pngHeader.getImageWidth());
            pngDirectory.setInt(2, pngHeader.getImageHeight());
            pngDirectory.setInt(3, pngHeader.getBitsPerSample());
            pngDirectory.setInt(4, pngHeader.getColorType().getNumericValue());
            pngDirectory.setInt(5, pngHeader.getCompressionType());
            pngDirectory.setInt(6, pngHeader.getFilterMethod());
            pngDirectory.setInt(7, pngHeader.getInterlaceMethod());
            metadata.addDirectory(pngDirectory);
        } else if (pngChunkType.equals(PngChunkType.PLTE)) {
            PngDirectory pngDirectory = new PngDirectory(PngChunkType.PLTE);
            pngDirectory.setInt(8, byArray.length / 3);
            metadata.addDirectory(pngDirectory);
        } else if (pngChunkType.equals(PngChunkType.tRNS)) {
            PngDirectory pngDirectory = new PngDirectory(PngChunkType.tRNS);
            pngDirectory.setInt(9, 1);
            metadata.addDirectory(pngDirectory);
        } else if (pngChunkType.equals(PngChunkType.sRGB)) {
            byte by = byArray[0];
            PngDirectory pngDirectory = new PngDirectory(PngChunkType.sRGB);
            pngDirectory.setInt(10, by);
            metadata.addDirectory(pngDirectory);
        } else if (pngChunkType.equals(PngChunkType.cHRM)) {
            PngChromaticities pngChromaticities = new PngChromaticities(byArray);
            PngChromaticitiesDirectory pngChromaticitiesDirectory = new PngChromaticitiesDirectory();
            pngChromaticitiesDirectory.setInt(1, pngChromaticities.getWhitePointX());
            pngChromaticitiesDirectory.setInt(2, pngChromaticities.getWhitePointY());
            pngChromaticitiesDirectory.setInt(3, pngChromaticities.getRedX());
            pngChromaticitiesDirectory.setInt(4, pngChromaticities.getRedY());
            pngChromaticitiesDirectory.setInt(5, pngChromaticities.getGreenX());
            pngChromaticitiesDirectory.setInt(6, pngChromaticities.getGreenY());
            pngChromaticitiesDirectory.setInt(7, pngChromaticities.getBlueX());
            pngChromaticitiesDirectory.setInt(8, pngChromaticities.getBlueY());
            metadata.addDirectory(pngChromaticitiesDirectory);
        } else if (pngChunkType.equals(PngChunkType.gAMA)) {
            int n = ByteConvert.toInt32BigEndian(byArray);
            new SequentialByteArrayReader(byArray).getInt32();
            PngDirectory pngDirectory = new PngDirectory(PngChunkType.gAMA);
            pngDirectory.setDouble(11, (double)n / 100000.0);
            metadata.addDirectory(pngDirectory);
        } else if (pngChunkType.equals(PngChunkType.iCCP)) {
            SequentialByteArrayReader sequentialByteArrayReader = new SequentialByteArrayReader(byArray);
            String string = sequentialByteArrayReader.getNullTerminatedString(79);
            PngDirectory pngDirectory = new PngDirectory(PngChunkType.iCCP);
            pngDirectory.setString(12, string);
            byte by = sequentialByteArrayReader.getInt8();
            if (by == 0) {
                int n = byArray.length - string.length() - 2;
                byte[] byArray2 = ((SequentialReader)sequentialByteArrayReader).getBytes(n);
                InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray2));
                new IccReader().extract(new RandomAccessStreamReader(inflaterInputStream), metadata, pngDirectory);
                inflaterInputStream.close();
            } else {
                pngDirectory.addError("Invalid compression method value");
            }
            metadata.addDirectory(pngDirectory);
        } else if (pngChunkType.equals(PngChunkType.bKGD)) {
            PngDirectory pngDirectory = new PngDirectory(PngChunkType.bKGD);
            pngDirectory.setByteArray(15, byArray);
            metadata.addDirectory(pngDirectory);
        } else if (pngChunkType.equals(PngChunkType.tEXt)) {
            SequentialByteArrayReader sequentialByteArrayReader = new SequentialByteArrayReader(byArray);
            String string = sequentialByteArrayReader.getNullTerminatedString(79);
            int n = byArray.length - string.length() - 1;
            String string2 = sequentialByteArrayReader.getNullTerminatedString(n);
            ArrayList<KeyValuePair> arrayList = new ArrayList<KeyValuePair>();
            arrayList.add(new KeyValuePair(string, string2));
            PngDirectory pngDirectory = new PngDirectory(PngChunkType.iTXt);
            pngDirectory.setObject(13, arrayList);
            metadata.addDirectory(pngDirectory);
        } else if (pngChunkType.equals(PngChunkType.iTXt)) {
            Object object;
            SequentialByteArrayReader sequentialByteArrayReader = new SequentialByteArrayReader(byArray);
            String string = sequentialByteArrayReader.getNullTerminatedString(79);
            byte by = sequentialByteArrayReader.getInt8();
            byte by2 = sequentialByteArrayReader.getInt8();
            String string3 = sequentialByteArrayReader.getNullTerminatedString(byArray.length);
            String string4 = sequentialByteArrayReader.getNullTerminatedString(byArray.length);
            int n = byArray.length - string.length() - 1 - 1 - 1 - string3.length() - 1 - string4.length() - 1;
            String string5 = null;
            if (by == 0) {
                string5 = sequentialByteArrayReader.getNullTerminatedString(n);
            } else if (by == 1) {
                if (by2 == 0) {
                    string5 = StringUtil.fromStream(new InflaterInputStream(new ByteArrayInputStream(byArray, byArray.length - n, n)));
                } else {
                    object = new PngDirectory(PngChunkType.iTXt);
                    ((Directory)object).addError("Invalid compression method value");
                    metadata.addDirectory(object);
                }
            } else {
                object = new PngDirectory(PngChunkType.iTXt);
                ((Directory)object).addError("Invalid compression flag value");
                metadata.addDirectory(object);
            }
            if (string5 != null) {
                if (string.equals("XML:com.adobe.xmp")) {
                    new XmpReader().extract(string5, metadata);
                } else {
                    object = new ArrayList();
                    object.add(new KeyValuePair(string, string5));
                    PngDirectory pngDirectory = new PngDirectory(PngChunkType.iTXt);
                    pngDirectory.setObject(13, object);
                    metadata.addDirectory(pngDirectory);
                }
            }
        } else if (pngChunkType.equals(PngChunkType.tIME)) {
            SequentialByteArrayReader sequentialByteArrayReader = new SequentialByteArrayReader(byArray);
            int n = sequentialByteArrayReader.getUInt16();
            short s = sequentialByteArrayReader.getUInt8();
            short s2 = sequentialByteArrayReader.getUInt8();
            short s3 = sequentialByteArrayReader.getUInt8();
            short s4 = sequentialByteArrayReader.getUInt8();
            short s5 = sequentialByteArrayReader.getUInt8();
            PngDirectory pngDirectory = new PngDirectory(PngChunkType.tIME);
            if (DateUtil.isValidDate(n, s - 1, s2) && DateUtil.isValidTime(s3, s4, s5)) {
                String string = String.format("%04d:%02d:%02d %02d:%02d:%02d", n, (int)s, (int)s2, (int)s3, (int)s4, (int)s5);
                pngDirectory.setString(14, string);
            } else {
                pngDirectory.addError(String.format("PNG tIME data describes an invalid date/time: year=%d month=%d day=%d hour=%d minute=%d second=%d", n, (int)s, (int)s2, (int)s3, (int)s4, (int)s5));
            }
            metadata.addDirectory(pngDirectory);
        } else if (pngChunkType.equals(PngChunkType.pHYs)) {
            SequentialByteArrayReader sequentialByteArrayReader = new SequentialByteArrayReader(byArray);
            int n = sequentialByteArrayReader.getInt32();
            int n2 = sequentialByteArrayReader.getInt32();
            byte by = sequentialByteArrayReader.getInt8();
            PngDirectory pngDirectory = new PngDirectory(PngChunkType.pHYs);
            pngDirectory.setInt(16, n);
            pngDirectory.setInt(17, n2);
            pngDirectory.setInt(18, by);
            metadata.addDirectory(pngDirectory);
        } else if (pngChunkType.equals(PngChunkType.sBIT)) {
            PngDirectory pngDirectory = new PngDirectory(PngChunkType.sBIT);
            pngDirectory.setByteArray(19, byArray);
            metadata.addDirectory(pngDirectory);
        }
    }

    static {
        HashSet<PngChunkType> hashSet = new HashSet<PngChunkType>();
        hashSet.add(PngChunkType.IHDR);
        hashSet.add(PngChunkType.PLTE);
        hashSet.add(PngChunkType.tRNS);
        hashSet.add(PngChunkType.cHRM);
        hashSet.add(PngChunkType.sRGB);
        hashSet.add(PngChunkType.gAMA);
        hashSet.add(PngChunkType.iCCP);
        hashSet.add(PngChunkType.bKGD);
        hashSet.add(PngChunkType.tEXt);
        hashSet.add(PngChunkType.iTXt);
        hashSet.add(PngChunkType.tIME);
        hashSet.add(PngChunkType.pHYs);
        hashSet.add(PngChunkType.sBIT);
        _desiredChunkTypes = Collections.unmodifiableSet(hashSet);
    }
}

