/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.imaging.tiff.TiffReader;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifInteropDirectory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.exif.ExifThumbnailDirectory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.exif.makernotes.CanonMakernoteDirectory;
import com.drew.metadata.exif.makernotes.CasioType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.CasioType2MakernoteDirectory;
import com.drew.metadata.exif.makernotes.FujifilmMakernoteDirectory;
import com.drew.metadata.exif.makernotes.KodakMakernoteDirectory;
import com.drew.metadata.exif.makernotes.KyoceraMakernoteDirectory;
import com.drew.metadata.exif.makernotes.LeicaMakernoteDirectory;
import com.drew.metadata.exif.makernotes.NikonType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.NikonType2MakernoteDirectory;
import com.drew.metadata.exif.makernotes.OlympusCameraSettingsMakernoteDirectory;
import com.drew.metadata.exif.makernotes.OlympusEquipmentMakernoteDirectory;
import com.drew.metadata.exif.makernotes.OlympusMakernoteDirectory;
import com.drew.metadata.exif.makernotes.PanasonicMakernoteDirectory;
import com.drew.metadata.exif.makernotes.PentaxMakernoteDirectory;
import com.drew.metadata.exif.makernotes.RicohMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SanyoMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SigmaMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SonyType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.SonyType6MakernoteDirectory;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.tiff.DirectoryTiffHandler;
import com.drew.metadata.xmp.XmpReader;
import java.io.IOException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExifTiffHandler
extends DirectoryTiffHandler {
    private final boolean _storeThumbnailBytes;

    public ExifTiffHandler(@NotNull Metadata metadata, boolean bl, @Nullable Directory directory) {
        super(metadata, ExifIFD0Directory.class);
        this._storeThumbnailBytes = bl;
        if (directory != null) {
            this._currentDirectory.setParent(directory);
        }
    }

    @Override
    public void setTiffMarker(int n) throws TiffProcessingException {
        if (n != 42 && n != 20306 && n != 21330 && n != 85) {
            throw new TiffProcessingException("Unexpected TIFF marker: 0x" + Integer.toHexString(n));
        }
    }

    @Override
    public boolean tryEnterSubIfd(int n) {
        if (n == 330) {
            this.pushDirectory(ExifSubIFDDirectory.class);
            return true;
        }
        if (this._currentDirectory instanceof ExifIFD0Directory) {
            if (n == 34665) {
                this.pushDirectory(ExifSubIFDDirectory.class);
                return true;
            }
            if (n == 34853) {
                this.pushDirectory(GpsDirectory.class);
                return true;
            }
        }
        if (this._currentDirectory instanceof ExifSubIFDDirectory && n == 40965) {
            this.pushDirectory(ExifInteropDirectory.class);
            return true;
        }
        if (this._currentDirectory instanceof OlympusMakernoteDirectory) {
            if (n == 8208) {
                this.pushDirectory(OlympusEquipmentMakernoteDirectory.class);
                return true;
            }
            if (n == 8224) {
                this.pushDirectory(OlympusCameraSettingsMakernoteDirectory.class);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasFollowerIfd() {
        if (this._currentDirectory instanceof ExifIFD0Directory) {
            this.pushDirectory(ExifThumbnailDirectory.class);
            return true;
        }
        return this._currentDirectory instanceof ExifThumbnailDirectory;
    }

    @Override
    @Nullable
    public Long tryCustomProcessFormat(int n, int n2, long l) {
        if (n2 == 13) {
            return l * 4L;
        }
        return null;
    }

    @Override
    public boolean customProcessTag(int n, @NotNull Set<Integer> set, int n2, @NotNull RandomAccessReader randomAccessReader, int n3, int n4) throws IOException {
        if (n3 == 37500 && this._currentDirectory instanceof ExifSubIFDDirectory) {
            return this.processMakernote(n, set, n2, randomAccessReader);
        }
        if (n3 == 33723 && this._currentDirectory instanceof ExifIFD0Directory) {
            if (randomAccessReader.getInt8(n) == 28) {
                byte[] byArray = randomAccessReader.getBytes(n, n4);
                new IptcReader().extract(new SequentialByteArrayReader(byArray), this._metadata, byArray.length, this._currentDirectory);
                return true;
            }
            return false;
        }
        if (n3 == 700 && this._currentDirectory instanceof ExifIFD0Directory) {
            new XmpReader().extract(randomAccessReader.getNullTerminatedString(n, n4), this._metadata, this._currentDirectory);
            return true;
        }
        return false;
    }

    @Override
    public void completed(@NotNull RandomAccessReader randomAccessReader, int n) {
        ExifThumbnailDirectory exifThumbnailDirectory;
        if (this._storeThumbnailBytes && (exifThumbnailDirectory = this._metadata.getFirstDirectoryOfType(ExifThumbnailDirectory.class)) != null && exifThumbnailDirectory.containsTag(259)) {
            Integer n2 = exifThumbnailDirectory.getInteger(513);
            Integer n3 = exifThumbnailDirectory.getInteger(514);
            if (n2 != null && n3 != null) {
                try {
                    byte[] byArray = randomAccessReader.getBytes(n + n2, n3);
                    exifThumbnailDirectory.setThumbnailData(byArray);
                }
                catch (IOException iOException) {
                    exifThumbnailDirectory.addError("Invalid thumbnail data specification: " + iOException.getMessage());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processMakernote(int n, @NotNull Set<Integer> set, int n2, @NotNull RandomAccessReader randomAccessReader) throws IOException {
        ExifIFD0Directory exifIFD0Directory = this._metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
        if (exifIFD0Directory == null) {
            return false;
        }
        String string = exifIFD0Directory.getString(271);
        String string2 = randomAccessReader.getString(n, 2);
        String string3 = randomAccessReader.getString(n, 3);
        String string4 = randomAccessReader.getString(n, 4);
        String string5 = randomAccessReader.getString(n, 5);
        String string6 = randomAccessReader.getString(n, 6);
        String string7 = randomAccessReader.getString(n, 7);
        String string8 = randomAccessReader.getString(n, 8);
        String string9 = randomAccessReader.getString(n, 10);
        String string10 = randomAccessReader.getString(n, 12);
        boolean bl = randomAccessReader.isMotorolaByteOrder();
        if ("OLYMP\u0000".equals(string6) || "EPSON".equals(string5) || "AGFA".equals(string4)) {
            this.pushDirectory(OlympusMakernoteDirectory.class);
            TiffReader.processIfd(this, randomAccessReader, set, n + 8, n2);
        } else if ("OLYMPUS\u0000II".equals(string9)) {
            this.pushDirectory(OlympusMakernoteDirectory.class);
            TiffReader.processIfd(this, randomAccessReader, set, n + 12, n);
        } else if (string != null && string.toUpperCase().startsWith("MINOLTA")) {
            this.pushDirectory(OlympusMakernoteDirectory.class);
            TiffReader.processIfd(this, randomAccessReader, set, n, n2);
        } else if (string != null && string.trim().toUpperCase().startsWith("NIKON")) {
            if ("Nikon".equals(string5)) {
                switch (randomAccessReader.getUInt8(n + 6)) {
                    case 1: {
                        this.pushDirectory(NikonType1MakernoteDirectory.class);
                        TiffReader.processIfd(this, randomAccessReader, set, n + 8, n2);
                        break;
                    }
                    case 2: {
                        this.pushDirectory(NikonType2MakernoteDirectory.class);
                        TiffReader.processIfd(this, randomAccessReader, set, n + 18, n + 10);
                        break;
                    }
                    default: {
                        exifIFD0Directory.addError("Unsupported Nikon makernote data ignored.");
                        break;
                    }
                }
            } else {
                this.pushDirectory(NikonType2MakernoteDirectory.class);
                TiffReader.processIfd(this, randomAccessReader, set, n, n2);
            }
        } else if ("SONY CAM".equals(string8) || "SONY DSC".equals(string8)) {
            this.pushDirectory(SonyType1MakernoteDirectory.class);
            TiffReader.processIfd(this, randomAccessReader, set, n + 12, n2);
        } else if ("SEMC MS\u0000\u0000\u0000\u0000\u0000".equals(string10)) {
            randomAccessReader.setMotorolaByteOrder(true);
            this.pushDirectory(SonyType6MakernoteDirectory.class);
            TiffReader.processIfd(this, randomAccessReader, set, n + 20, n2);
        } else if ("SIGMA\u0000\u0000\u0000".equals(string8) || "FOVEON\u0000\u0000".equals(string8)) {
            this.pushDirectory(SigmaMakernoteDirectory.class);
            TiffReader.processIfd(this, randomAccessReader, set, n + 10, n2);
        } else if ("KDK".equals(string3)) {
            randomAccessReader.setMotorolaByteOrder(string7.equals("KDK INFO"));
            KodakMakernoteDirectory kodakMakernoteDirectory = new KodakMakernoteDirectory();
            this._metadata.addDirectory(kodakMakernoteDirectory);
            ExifTiffHandler.processKodakMakernote(kodakMakernoteDirectory, n, randomAccessReader);
        } else if ("Canon".equalsIgnoreCase(string)) {
            this.pushDirectory(CanonMakernoteDirectory.class);
            TiffReader.processIfd(this, randomAccessReader, set, n, n2);
        } else if (string != null && string.toUpperCase().startsWith("CASIO")) {
            if ("QVC\u0000\u0000\u0000".equals(string6)) {
                this.pushDirectory(CasioType2MakernoteDirectory.class);
                TiffReader.processIfd(this, randomAccessReader, set, n + 6, n2);
            } else {
                this.pushDirectory(CasioType1MakernoteDirectory.class);
                TiffReader.processIfd(this, randomAccessReader, set, n, n2);
            }
        } else if ("FUJIFILM".equals(string8) || "Fujifilm".equalsIgnoreCase(string)) {
            randomAccessReader.setMotorolaByteOrder(false);
            int n3 = n + randomAccessReader.getInt32(n + 8);
            this.pushDirectory(FujifilmMakernoteDirectory.class);
            TiffReader.processIfd(this, randomAccessReader, set, n3, n);
        } else if ("KYOCERA".equals(string7)) {
            this.pushDirectory(KyoceraMakernoteDirectory.class);
            TiffReader.processIfd(this, randomAccessReader, set, n + 22, n2);
        } else if ("LEICA".equals(string5)) {
            randomAccessReader.setMotorolaByteOrder(false);
            if ("Leica Camera AG".equals(string)) {
                this.pushDirectory(LeicaMakernoteDirectory.class);
                TiffReader.processIfd(this, randomAccessReader, set, n + 8, n2);
            } else {
                if (!"LEICA".equals(string)) return false;
                this.pushDirectory(PanasonicMakernoteDirectory.class);
                TiffReader.processIfd(this, randomAccessReader, set, n + 8, n2);
            }
        } else if ("Panasonic\u0000\u0000\u0000".equals(randomAccessReader.getString(n, 12))) {
            this.pushDirectory(PanasonicMakernoteDirectory.class);
            TiffReader.processIfd(this, randomAccessReader, set, n + 12, n2);
        } else if ("AOC\u0000".equals(string4)) {
            this.pushDirectory(CasioType2MakernoteDirectory.class);
            TiffReader.processIfd(this, randomAccessReader, set, n + 6, n);
        } else if (string != null && (string.toUpperCase().startsWith("PENTAX") || string.toUpperCase().startsWith("ASAHI"))) {
            this.pushDirectory(PentaxMakernoteDirectory.class);
            TiffReader.processIfd(this, randomAccessReader, set, n, n);
        } else if ("SANYO\u0000\u0001\u0000".equals(string8)) {
            this.pushDirectory(SanyoMakernoteDirectory.class);
            TiffReader.processIfd(this, randomAccessReader, set, n + 8, n);
        } else {
            if (string == null || !string.toLowerCase().startsWith("ricoh")) return false;
            if (string2.equals("Rv") || string3.equals("Rev")) {
                return false;
            }
            if (string5.equalsIgnoreCase("Ricoh")) {
                randomAccessReader.setMotorolaByteOrder(true);
                this.pushDirectory(RicohMakernoteDirectory.class);
                TiffReader.processIfd(this, randomAccessReader, set, n + 8, n);
            }
        }
        randomAccessReader.setMotorolaByteOrder(bl);
        return true;
    }

    private static void processKodakMakernote(@NotNull KodakMakernoteDirectory kodakMakernoteDirectory, int n, @NotNull RandomAccessReader randomAccessReader) {
        int n2 = n + 8;
        try {
            kodakMakernoteDirectory.setString(0, randomAccessReader.getString(n2, 8));
            kodakMakernoteDirectory.setInt(9, randomAccessReader.getUInt8(n2 + 9));
            kodakMakernoteDirectory.setInt(10, randomAccessReader.getUInt8(n2 + 10));
            kodakMakernoteDirectory.setInt(12, randomAccessReader.getUInt16(n2 + 12));
            kodakMakernoteDirectory.setInt(14, randomAccessReader.getUInt16(n2 + 14));
            kodakMakernoteDirectory.setInt(16, randomAccessReader.getUInt16(n2 + 16));
            kodakMakernoteDirectory.setByteArray(18, randomAccessReader.getBytes(n2 + 18, 2));
            kodakMakernoteDirectory.setByteArray(20, randomAccessReader.getBytes(n2 + 20, 4));
            kodakMakernoteDirectory.setInt(24, randomAccessReader.getUInt16(n2 + 24));
            kodakMakernoteDirectory.setInt(27, randomAccessReader.getUInt8(n2 + 27));
            kodakMakernoteDirectory.setInt(28, randomAccessReader.getUInt8(n2 + 28));
            kodakMakernoteDirectory.setInt(29, randomAccessReader.getUInt8(n2 + 29));
            kodakMakernoteDirectory.setInt(30, randomAccessReader.getUInt16(n2 + 30));
            kodakMakernoteDirectory.setLong(32, randomAccessReader.getUInt32(n2 + 32));
            kodakMakernoteDirectory.setInt(36, randomAccessReader.getInt16(n2 + 36));
            kodakMakernoteDirectory.setInt(56, randomAccessReader.getUInt8(n2 + 56));
            kodakMakernoteDirectory.setInt(64, randomAccessReader.getUInt8(n2 + 64));
            kodakMakernoteDirectory.setInt(92, randomAccessReader.getUInt8(n2 + 92));
            kodakMakernoteDirectory.setInt(93, randomAccessReader.getUInt8(n2 + 93));
            kodakMakernoteDirectory.setInt(94, randomAccessReader.getUInt16(n2 + 94));
            kodakMakernoteDirectory.setInt(96, randomAccessReader.getUInt16(n2 + 96));
            kodakMakernoteDirectory.setInt(98, randomAccessReader.getUInt16(n2 + 98));
            kodakMakernoteDirectory.setInt(100, randomAccessReader.getUInt16(n2 + 100));
            kodakMakernoteDirectory.setInt(102, randomAccessReader.getUInt16(n2 + 102));
            kodakMakernoteDirectory.setInt(104, randomAccessReader.getUInt16(n2 + 104));
            kodakMakernoteDirectory.setInt(107, randomAccessReader.getInt8(n2 + 107));
        }
        catch (IOException iOException) {
            kodakMakernoteDirectory.addError("Error processing Kodak makernote data: " + iOException.getMessage());
        }
    }
}

