/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.icc;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.DateUtil;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.icc.IccDirectory;
import java.io.IOException;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IccReader
implements JpegSegmentMetadataReader,
MetadataReader {
    public static final String JPEG_SEGMENT_PREAMBLE = "ICC_PROFILE";

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Collections.singletonList(JpegSegmentType.APP2);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> iterable, @NotNull Metadata metadata, @NotNull JpegSegmentType jpegSegmentType) {
        int n = JPEG_SEGMENT_PREAMBLE.length();
        byte[] byArray = null;
        for (byte[] byArray2 : iterable) {
            if (byArray2.length < n || !JPEG_SEGMENT_PREAMBLE.equalsIgnoreCase(new String(byArray2, 0, n))) continue;
            if (byArray == null) {
                byArray = new byte[byArray2.length - 14];
                System.arraycopy(byArray2, 14, byArray, 0, byArray2.length - 14);
                continue;
            }
            byte[] byArray3 = new byte[byArray.length + byArray2.length - 14];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 14, byArray3, byArray.length, byArray2.length - 14);
            byArray = byArray3;
        }
        if (byArray != null) {
            this.extract(new ByteArrayReader(byArray), metadata);
        }
    }

    @Override
    public void extract(@NotNull RandomAccessReader randomAccessReader, @NotNull Metadata metadata) {
        this.extract(randomAccessReader, metadata, null);
    }

    public void extract(@NotNull RandomAccessReader randomAccessReader, @NotNull Metadata metadata, @Nullable Directory directory) {
        IccDirectory iccDirectory = new IccDirectory();
        if (directory != null) {
            iccDirectory.setParent(directory);
        }
        try {
            int n = randomAccessReader.getInt32(0);
            iccDirectory.setInt(0, n);
            this.set4ByteString(iccDirectory, 4, randomAccessReader);
            this.setInt32(iccDirectory, 8, randomAccessReader);
            this.set4ByteString(iccDirectory, 12, randomAccessReader);
            this.set4ByteString(iccDirectory, 16, randomAccessReader);
            this.set4ByteString(iccDirectory, 20, randomAccessReader);
            this.setDate(iccDirectory, 24, randomAccessReader);
            this.set4ByteString(iccDirectory, 36, randomAccessReader);
            this.set4ByteString(iccDirectory, 40, randomAccessReader);
            this.setInt32(iccDirectory, 44, randomAccessReader);
            this.set4ByteString(iccDirectory, 48, randomAccessReader);
            int n2 = randomAccessReader.getInt32(52);
            if (n2 != 0) {
                if (n2 <= 0x20202020) {
                    iccDirectory.setInt(52, n2);
                } else {
                    iccDirectory.setString(52, IccReader.getStringFromInt32(n2));
                }
            }
            this.setInt32(iccDirectory, 64, randomAccessReader);
            this.setInt64(iccDirectory, 56, randomAccessReader);
            float[] fArray = new float[]{randomAccessReader.getS15Fixed16(68), randomAccessReader.getS15Fixed16(72), randomAccessReader.getS15Fixed16(76)};
            iccDirectory.setObject(68, fArray);
            int n3 = randomAccessReader.getInt32(128);
            iccDirectory.setInt(128, n3);
            for (int i = 0; i < n3; ++i) {
                int n4 = 132 + i * 12;
                int n5 = randomAccessReader.getInt32(n4);
                int n6 = randomAccessReader.getInt32(n4 + 4);
                int n7 = randomAccessReader.getInt32(n4 + 8);
                byte[] byArray = randomAccessReader.getBytes(n6, n7);
                iccDirectory.setByteArray(n5, byArray);
            }
        }
        catch (IOException iOException) {
            iccDirectory.addError("Exception reading ICC profile: " + iOException.getMessage());
        }
        metadata.addDirectory(iccDirectory);
    }

    private void set4ByteString(@NotNull Directory directory, int n, @NotNull RandomAccessReader randomAccessReader) throws IOException {
        int n2 = randomAccessReader.getInt32(n);
        if (n2 != 0) {
            directory.setString(n, IccReader.getStringFromInt32(n2));
        }
    }

    private void setInt32(@NotNull Directory directory, int n, @NotNull RandomAccessReader randomAccessReader) throws IOException {
        int n2 = randomAccessReader.getInt32(n);
        if (n2 != 0) {
            directory.setInt(n, n2);
        }
    }

    private void setInt64(@NotNull Directory directory, int n, @NotNull RandomAccessReader randomAccessReader) throws IOException {
        long l = randomAccessReader.getInt64(n);
        if (l != 0L) {
            directory.setLong(n, l);
        }
    }

    private void setDate(@NotNull IccDirectory iccDirectory, int n, @NotNull RandomAccessReader randomAccessReader) throws IOException {
        int n2 = randomAccessReader.getUInt16(n);
        int n3 = randomAccessReader.getUInt16(n + 2);
        int n4 = randomAccessReader.getUInt16(n + 4);
        int n5 = randomAccessReader.getUInt16(n + 6);
        int n6 = randomAccessReader.getUInt16(n + 8);
        int n7 = randomAccessReader.getUInt16(n + 10);
        if (DateUtil.isValidDate(n2, n3 - 1, n4) && DateUtil.isValidTime(n5, n6, n7)) {
            String string = String.format("%04d:%02d:%02d %02d:%02d:%02d", n2, n3, n4, n5, n6, n7);
            iccDirectory.setString(n, string);
        } else {
            iccDirectory.addError(String.format("ICC data describes an invalid date/time: year=%d month=%d day=%d hour=%d minute=%d second=%d", n2, n3, n4, n5, n6, n7));
        }
    }

    @NotNull
    public static String getStringFromInt32(int n) {
        byte[] byArray = new byte[]{(byte)((n & 0xFF000000) >> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
        return new String(byArray);
    }
}

