/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.webp;

import com.drew.imaging.riff.RiffHandler;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.icc.IccReader;
import com.drew.metadata.webp.WebpDirectory;
import com.drew.metadata.xmp.XmpReader;
import java.io.IOException;

public class WebpRiffHandler
implements RiffHandler {
    @NotNull
    private final Metadata _metadata;

    public WebpRiffHandler(@NotNull Metadata metadata) {
        this._metadata = metadata;
    }

    public boolean shouldAcceptRiffIdentifier(@NotNull String string) {
        return string.equals("WEBP");
    }

    public boolean shouldAcceptChunk(@NotNull String string) {
        return string.equals("VP8X") || string.equals("VP8L") || string.equals("VP8 ") || string.equals("EXIF") || string.equals("ICCP") || string.equals("XMP ");
    }

    public void processChunk(@NotNull String string, @NotNull byte[] byArray) {
        if (string.equals("EXIF")) {
            new ExifReader().extract(new ByteArrayReader(byArray), this._metadata);
        } else if (string.equals("ICCP")) {
            new IccReader().extract(new ByteArrayReader(byArray), this._metadata);
        } else if (string.equals("XMP ")) {
            new XmpReader().extract(byArray, this._metadata);
        } else if (string.equals("VP8X") && byArray.length == 10) {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            byteArrayReader.setMotorolaByteOrder(false);
            try {
                boolean bl = byteArrayReader.getBit(1);
                boolean bl2 = byteArrayReader.getBit(4);
                int n = byteArrayReader.getInt24(4);
                int n2 = byteArrayReader.getInt24(7);
                WebpDirectory webpDirectory = new WebpDirectory();
                webpDirectory.setInt(2, n + 1);
                webpDirectory.setInt(1, n2 + 1);
                webpDirectory.setBoolean(3, bl2);
                webpDirectory.setBoolean(4, bl);
                this._metadata.addDirectory(webpDirectory);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        } else if (string.equals("VP8L") && byArray.length > 4) {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            byteArrayReader.setMotorolaByteOrder(false);
            try {
                if (byteArrayReader.getInt8(0) != 47) {
                    return;
                }
                short s = byteArrayReader.getUInt8(1);
                short s2 = byteArrayReader.getUInt8(2);
                short s3 = byteArrayReader.getUInt8(3);
                short s4 = byteArrayReader.getUInt8(4);
                int n = (s2 & 0x3F) << 8 | s;
                int n3 = (s4 & 0xF) << 10 | s3 << 2 | (s2 & 0xC0) >> 6;
                WebpDirectory webpDirectory = new WebpDirectory();
                webpDirectory.setInt(2, n + 1);
                webpDirectory.setInt(1, n3 + 1);
                this._metadata.addDirectory(webpDirectory);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        } else if (string.equals("VP8 ") && byArray.length > 9) {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            byteArrayReader.setMotorolaByteOrder(false);
            try {
                if (byteArrayReader.getUInt8(3) != 157 || byteArrayReader.getUInt8(4) != 1 || byteArrayReader.getUInt8(5) != 42) {
                    return;
                }
                int n = byteArrayReader.getUInt16(6);
                int n4 = byteArrayReader.getUInt16(8);
                WebpDirectory webpDirectory = new WebpDirectory();
                webpDirectory.setInt(2, n);
                webpDirectory.setInt(1, n4);
                this._metadata.addDirectory(webpDirectory);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
    }
}

