/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.dummy;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamResolution;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicBoolean;

public class WebcamDummyDevice
implements WebcamDevice {
    private static final Dimension[] DIMENSIONS = new Dimension[]{WebcamResolution.QQVGA.getSize(), WebcamResolution.QVGA.getSize(), WebcamResolution.VGA.getSize()};
    private AtomicBoolean open = new AtomicBoolean(false);
    private Dimension resolution = DIMENSIONS[0];
    private final String name;
    byte r = (byte)(Math.random() * 127.0);
    byte g = (byte)(Math.random() * 127.0);
    byte b = (byte)(Math.random() * 127.0);

    public WebcamDummyDevice(int number) {
        this.name = "Dummy Webcam " + number;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Dimension[] getResolutions() {
        return DIMENSIONS;
    }

    @Override
    public Dimension getResolution() {
        return this.resolution;
    }

    @Override
    public void setResolution(Dimension size) {
        this.resolution = size;
    }

    private void drawRect(Graphics2D g2, int w, int h) {
        int rx = (int)((double)w * Math.random() / 1.5);
        int ry = (int)((double)h * Math.random() / 1.5);
        int rw = (int)((double)w * Math.random() / 1.5);
        int rh = (int)((double)w * Math.random() / 1.5);
        g2.setColor(new Color((int)(2.147483647E9 * Math.random())));
        g2.fillRect(rx, ry, rw, rh);
    }

    @Override
    public BufferedImage getImage() {
        if (!this.isOpen()) {
            throw new WebcamException("Webcam is not open");
        }
        try {
            Thread.sleep(33L);
        }
        catch (InterruptedException e) {
            return null;
        }
        Dimension resolution = this.getResolution();
        int w = resolution.width;
        int h = resolution.height;
        String s = this.getName();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bi = gc.createCompatibleImage(w, h);
        Graphics2D g2 = ge.createGraphics(bi);
        byte by = this.r;
        this.r = (byte)(by + 1);
        byte by2 = this.g;
        this.g = (byte)(by2 + 1);
        byte by3 = this.b;
        this.b = (byte)(by3 + 1);
        g2.setBackground(new Color(Math.abs(by), Math.abs(by2), Math.abs(by3)));
        g2.clearRect(0, 0, w, h);
        this.drawRect(g2, w, h);
        this.drawRect(g2, w, h);
        this.drawRect(g2, w, h);
        this.drawRect(g2, w, h);
        this.drawRect(g2, w, h);
        Font font = new Font("sans-serif", 1, 16);
        g2.setFont(font);
        FontMetrics metrics = g2.getFontMetrics(font);
        int sw = (w - metrics.stringWidth(s)) / 2;
        int sh = (h - metrics.getHeight()) / 2 + metrics.getHeight() / 2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.BLACK);
        g2.drawString(s, sw + 1, sh + 1);
        g2.setColor(Color.WHITE);
        g2.drawString(s, sw, sh);
        g2.dispose();
        bi.flush();
        return bi;
    }

    @Override
    public void open() {
        if (this.open.compareAndSet(false, true)) {
            // empty if block
        }
    }

    @Override
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            // empty if block
        }
    }

    @Override
    public void dispose() {
        this.close();
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }
}

