/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc;

import java.util.LinkedList;
import java.util.List;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.IP_ADDR_STRING;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.misc.basicStructures.time_t;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;
import org.xvolks.jnative.pointers.memory.NativeMemoryBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IP_ADAPTER_INFO
extends AbstractBasicData<IP_ADAPTER_INFO> {
    public static final int MAX_ADAPTER_ADDRESS_LENGTH = 8;
    public static final int MAX_ADAPTER_DESCRIPTION_LENGTH = 128;
    public static final int MAX_ADAPTER_NAME_LENGTH = 256;
    private int Next;
    private DWORD ComboIndex = new DWORD(0);
    private String AdapterName;
    private String Description;
    private int AddressLength;
    private byte[] Address = new byte[8];
    private DWORD Index = new DWORD(0);
    private int Type;
    private int DhcpEnabled;
    private final Pointer CurrentIpAddress = NullPointer.NULL;
    private IP_ADDR_STRING IpAddressList;
    private IP_ADDR_STRING GatewayList;
    private IP_ADDR_STRING DhcpServer;
    private boolean HaveWins;
    private IP_ADDR_STRING PrimaryWinsServer;
    private IP_ADDR_STRING SecondaryWinsServer;
    private time_t LeaseObtained = new time_t(0);
    private time_t LeaseExpires = new time_t(0);

    public IP_ADAPTER_INFO() {
        super(null);
        try {
            this.createPointer();
        }
        catch (NativeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private IP_ADAPTER_INFO(int address) {
        super(null);
        this.pointer = new Pointer(new NativeMemoryBlock(address, this.getSizeOf()));
    }

    public static IP_ADAPTER_INFO fromAddress(int address) throws NativeException {
        return new IP_ADAPTER_INFO(address).getValueFromPointer();
    }

    private IP_ADAPTER_INFO(boolean dummy) {
        super(null);
        if (dummy) {
            throw new IllegalArgumentException("Dummy must be false, AH! Ah! AH!");
        }
    }

    public static Pointer reserveMemoryOf_IP_ADAPTER_INFO(int size) throws NativeException {
        if (size < 1) {
            return NullPointer.NULL;
        }
        return new Pointer(MemoryBlockFactory.createMemoryBlock(size * new IP_ADAPTER_INFO(false).getSizeOf()));
    }

    public static List<IP_ADAPTER_INFO> getListOf_IP_ADAPTER_INFO(Pointer p) throws NativeException {
        IP_ADAPTER_INFO ip_adapter_info = new IP_ADAPTER_INFO(false);
        int size = p.getSize() / ip_adapter_info.getSizeOf();
        if (size * ip_adapter_info.getSizeOf() != p.getSize()) {
            throw new IllegalArgumentException("The pointer passed in has not a IP_ADAPTER_INFO size boundary " + p.getSize() + " vs. " + ip_adapter_info.getSizeOf() + ". Call the other method if you are sure of what you are doing.");
        }
        return IP_ADAPTER_INFO.getListOf_IP_ADAPTER_INFO(p, size);
    }

    public static List<IP_ADAPTER_INFO> getListOf_IP_ADAPTER_INFO(Pointer p, int size) throws NativeException {
        IP_ADAPTER_INFO ip_adapter_info = new IP_ADAPTER_INFO(false);
        int totalSize = size * ip_adapter_info.getSizeOf();
        if (p.getSize() < totalSize) {
            throw new IllegalArgumentException("This pointer is addressing a too small memory region, size is " + p.getSize() + ", needed size is " + totalSize);
        }
        LinkedList<IP_ADAPTER_INFO> array = new LinkedList<IP_ADAPTER_INFO>();
        int address = p.getPointer();
        for (int i = 0; address != 0 && i < size; ++i) {
            ip_adapter_info = IP_ADAPTER_INFO.fromAddress(address);
            array.add(ip_adapter_info);
            address = ip_adapter_info.Next;
        }
        return array;
    }

    @Override
    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(this.getSizeOf()));
        return this.pointer;
    }

    @Override
    public int getSizeOf() {
        return 640;
    }

    private String getString(byte[] buffer, int pos, int len) {
        String s = new String(buffer, pos, len);
        int pos0 = s.indexOf(0);
        if (pos != -1) {
            s = s.substring(0, pos0);
        }
        return s;
    }

    @Override
    public IP_ADAPTER_INFO getValueFromPointer() throws NativeException {
        int pos = 0;
        byte[] mem = this.pointer.getMemory();
        this.Next = this.pointer.getAsInt(pos);
        this.ComboIndex.setValue(this.pointer.getAsInt(pos += 4));
        this.AdapterName = this.getString(mem, pos += 4, 260);
        this.Description = this.getString(mem, pos += 260, 132);
        this.AddressLength = this.pointer.getAsInt(pos += 132);
        System.arraycopy(mem, pos += 4, this.Address, 0, this.AddressLength);
        this.Index.setValue(this.pointer.getAsInt(pos += 8));
        this.Type = this.pointer.getAsInt(pos += 4);
        this.DhcpEnabled = this.pointer.getAsInt(pos += 4);
        pos += 4;
        this.IpAddressList = IP_ADDR_STRING.fromAddress(this.pointer.getPointer() + (pos += 4));
        this.GatewayList = IP_ADDR_STRING.fromAddress(this.pointer.getPointer() + (pos += this.IpAddressList.getSizeOf()));
        this.DhcpServer = IP_ADDR_STRING.fromAddress(this.pointer.getPointer() + (pos += this.GatewayList.getSizeOf()));
        this.HaveWins = this.pointer.getAsInt(pos += this.DhcpServer.getSizeOf()) != 0;
        this.PrimaryWinsServer = IP_ADDR_STRING.fromAddress(this.pointer.getPointer() + (pos += 4));
        this.SecondaryWinsServer = IP_ADDR_STRING.fromAddress(this.pointer.getPointer() + (pos += this.PrimaryWinsServer.getSizeOf()));
        this.LeaseObtained = new time_t(this.pointer.getAsInt(pos += this.SecondaryWinsServer.getSizeOf()));
        this.LeaseExpires = new time_t(this.pointer.getAsInt(pos += 4));
        return this;
    }

    public int getNext() {
        return this.Next;
    }

    public DWORD getComboIndex() {
        return this.ComboIndex;
    }

    public String getAdapterName() {
        return this.AdapterName;
    }

    public String getDescription() {
        return this.Description;
    }

    public int getAddressLength() {
        return this.AddressLength;
    }

    public String getAddressAsWindowsFormat() {
        return String.format("%02X-%02X-%02X-%02X-%02X-%02X", this.Address[0], this.Address[1], this.Address[2], this.Address[3], this.Address[4], this.Address[5]);
    }

    public String getAddressAsUnixFormat() {
        return String.format("%02x:%02x:%02x:%02x:%02x:%02x", this.Address[0], this.Address[1], this.Address[2], this.Address[3], this.Address[4], this.Address[5]);
    }

    public byte[] getAddress() {
        return this.Address;
    }

    public DWORD getIndex() {
        return this.Index;
    }

    public int getType() {
        return this.Type;
    }

    public int getDhcpEnabled() {
        return this.DhcpEnabled;
    }

    public Pointer getCurrentIpAddress() {
        return this.CurrentIpAddress;
    }

    public IP_ADDR_STRING getIpAddressList() {
        return this.IpAddressList;
    }

    public IP_ADDR_STRING getGatewayList() {
        return this.GatewayList;
    }

    public IP_ADDR_STRING getDhcpServer() {
        return this.DhcpServer;
    }

    public boolean isHaveWins() {
        return this.HaveWins;
    }

    public IP_ADDR_STRING getPrimaryWinsServer() {
        return this.PrimaryWinsServer;
    }

    public IP_ADDR_STRING getSecondaryWinsServer() {
        return this.SecondaryWinsServer;
    }

    public time_t getLeaseObtained() {
        return this.LeaseObtained;
    }

    public time_t getLeaseExpires() {
        return this.LeaseExpires;
    }
}

