/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util.mapi.structs;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.Pointer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapiFileDesc
extends AbstractBasicData<MapiFileDesc> {
    public LONG ulReserved = new LONG(0);
    public LONG flFlags = new LONG(0);
    public LONG nPosition = new LONG(0);
    public int lpszPathName;
    public int lpszFileName;
    public int lpFileType;

    public MapiFileDesc() throws NativeException {
        super(null);
        this.createPointer();
    }

    public MapiFileDesc(int nativeAddress) throws NativeException {
        this();
        this.pointer.setMemory(JNative.getMemory(nativeAddress, MapiFileDesc.sizeOf()));
        this.getValueFromPointer();
    }

    @Override
    public MapiFileDesc getValue() {
        return this;
    }

    @Override
    public MapiFileDesc getValueFromPointer() throws NativeException {
        this.offset = 0;
        this.ulReserved = new LONG(this.getNextInt());
        this.flFlags = new LONG(this.getNextInt());
        this.nPosition = new LONG(this.getNextInt());
        this.lpszPathName = this.getNextInt();
        this.lpszFileName = this.getNextInt();
        this.lpFileType = this.getNextInt();
        this.offset = 0;
        return this;
    }

    @Override
    public Pointer createPointer() throws NativeException {
        if (this.pointer != null) {
            int i = -4;
            this.pointer.setIntAt(i += 4, this.ulReserved.getValue());
            this.pointer.setIntAt(i += 4, this.flFlags.getValue());
            this.pointer.setIntAt(i += 4, this.nPosition.getValue());
            this.pointer.setIntAt(i += 4, this.lpszPathName);
            this.pointer.setIntAt(i += 4, this.lpszFileName);
            this.pointer.setIntAt(i += 4, this.lpFileType);
        } else {
            this.pointer = Pointer.createPointer(MapiFileDesc.sizeOf());
        }
        return this.pointer;
    }

    @Override
    public int getSizeOf() {
        return MapiFileDesc.sizeOf();
    }

    public static int sizeOf() {
        return 24;
    }
}

